package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.Company.Machine.AlMachineDatum;
import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.R;

public class EnterpriseRecyclerAdapter extends RecyclerView.Adapter<EnterpriseRecyclerAdapter.ItemViewHolder> {
    Context context;

    String agency_id, user_id;

    public int showPosition = 0;
    boolean first = false;

    // adapter에 들어갈 list 입니다.
    private ArrayList<AlMachineDatum> items = new ArrayList<>();

    public EnterpriseRecyclerAdapter(Context context, String agency_id, String user_id) {
        this.context = context;
        this.agency_id = agency_id;
        this.user_id = user_id;
    }

    @NonNull
    @Override
    public EnterpriseRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_enterprise, parent, false);
        return new EnterpriseRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull EnterpriseRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));

//        if (showPosition == position){
//            if (holder.content.getVisibility() == View.VISIBLE){
//                if (first){
//                    holder.content.setVisibility(View.GONE);
//                    holder.arrow.setImageResource(R.drawable.list_arrow_up_img);
//                }else{
//                    first = true;
//                }
//            }else{
//                holder.content.setVisibility(View.VISIBLE);
//                holder.arrow.setImageResource(R.drawable.list_arrow_down_img);
//                /*ArrayList<MachineItem> item = new ArrayList<>();
//                item.addAll(items.get(position).getItems());
//                holder.adapter.addItem(item);*/
//            }
//        }else{
//            holder.content.setVisibility(View.GONE);
//            holder.arrow.setImageResource(R.drawable.list_arrow_up_img);
//        }

        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (showPosition != position) {
                    showPosition = position;
                }

                notifyDataSetChanged();
            }
        });
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<AlMachineDatum> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }


    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView name, lastDt, noneList;
        ImageView arrow;
        LinearLayout content;
        RecyclerView list;
        EnterpriseProdRecyclerAdapter adapter;

        ItemViewHolder(View itemView) {
            super(itemView);
            name = itemView.findViewById(R.id.tv_item_enterprise_name);
//            arrow = itemView.findViewById(R.id.iv_item_enterprise_arrow);
            content = itemView.findViewById(R.id.ll_item_enterprise_content);
//            lastDt = itemView.findViewById(R.id.lastDt);
            noneList = itemView.findViewById(R.id.noneList);
            list = itemView.findViewById(R.id.list);
            adapter = new EnterpriseProdRecyclerAdapter(context, agency_id, user_id);
            list.setAdapter(adapter);

        }

        void onBind(AlMachineDatum data) {
            name.setText(data.getMcAirline());
//            if (data.getLastExchangeDt().equals("")){
//                lastDt.setText("교환정보 없음");
//            }else{
//                lastDt.setText(data.getLastExchangeDt());
//            }

            if (data.getItems().size() == 0) {
                list.setVisibility(View.GONE);
                noneList.setVisibility(View.VISIBLE);
            } else {
                ArrayList<MachineItem> item = new ArrayList<>();
                item.addAll(data.getItems());
                adapter.addItem(item);
            }
        }
    }
}
