package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.ImageList.ImageListData;
import kr.co.compcareworker.R;

public class ImageCheckListRecyclerAdapter extends RecyclerView.Adapter<ImageCheckListRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;

    // adapter에 들어갈 list 입니다.
    private ArrayList<ImageListData> items = new ArrayList<>();

    public ImageCheckListRecyclerAdapter(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
    }

    @NonNull
    @Override
    public ImageCheckListRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_image_check_list, parent, false);
        return new ImageCheckListRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ImageCheckListRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(context, FragmentActivity.class);
                intent.putExtra("title", "사진점검 이력");
                intent.putExtra("type", "image_check_detail");
                intent.putExtra("value1", items.get(position).getCpIdx());
                intent.putExtra("value2", items.get(position).getCkIdx());
                context.startActivity(intent);
            }
        });
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<ImageListData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView dt, contents, status;

        ItemViewHolder(View itemView) {
            super(itemView);
            dt = itemView.findViewById(R.id.dt);
            contents = itemView.findViewById(R.id.contents);
            status = itemView.findViewById(R.id.status);
        }

        void onBind(ImageListData data) {
            if (data.getInsDt() != null) {
                try {
                    SimpleDateFormat beforeSDF = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    Date beforeDate = beforeSDF.parse(data.getInsDt());
                    SimpleDateFormat afterSDF = new SimpleDateFormat("yyyy.MM.dd");
                    String afterDate = afterSDF.format(beforeDate);
                    dt.setText(afterDate);
                } catch (Exception e) {
                    dt.setText(data.getInsDt().split(" ")[0]);
                }

                contents.setText(data.getCkCont());
                if (!data.getCkStatusStr().equals("접수")) {
                    status.setText(data.getCkStatusStr());
                    status.setTextColor(context.getResources().getColor(R.color.color_bg_blue));
                    status.setBackgroundResource(R.drawable.border_blue);
                }
            }
        }
    }
}
