package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.ArrayList;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.ImageList.FileDatum;
import kr.co.compcareworker.R;

public class ImageListDetailRecyclerAdapter extends RecyclerView.Adapter<ImageListDetailRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;
    int itemHeight;

    // adapter에 들어갈 list 입니다.
    private ArrayList<FileDatum> items = new ArrayList<>();

    public ImageListDetailRecyclerAdapter(Context context, Handler handler, int itemHeight) {
        this.context = context;
        this.handler = handler;
        this.itemHeight = itemHeight;
    }

    @NonNull
    @Override
    public ImageListDetailRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_image_list_detail, parent, false);
        return new ImageListDetailRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ImageListDetailRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(context, FragmentActivity.class);
                intent.putExtra("title", "이미지 상세보기");
                intent.putExtra("type", "image_detail");
                intent.putExtra("value1", items.get(position).getUrl());
                context.startActivity(intent);
            }
        });
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<FileDatum> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        ImageView iv_item_picture_list_detail_image;
        String url;

        ItemViewHolder(View itemView) {
            super(itemView);
            iv_item_picture_list_detail_image = itemView.findViewById(R.id.iv_item_picture_list_detail_image);
        }

        void onBind(FileDatum data) {
            iv_item_picture_list_detail_image.getLayoutParams().height = itemHeight / items.size();
            Picasso
                    .with(context)
                    .load(data.getUrl())
                    .into(iv_item_picture_list_detail_image);

            url = data.getUrl();
        }
    }
}
