package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.ArrayList;

import kr.co.compcareworker.R;

public class ImageListRecyclerAdapter extends RecyclerView.Adapter<ImageListRecyclerAdapter.ItemViewHolder> {
    Context context;
    int itemHeight;

    // adapter에 들어갈 list 입니다.
    private ArrayList<String> items = new ArrayList<>();
    public ArrayList<String> dataImgNo = new ArrayList<>();

    public View.OnClickListener itemClick;

    public ImageListRecyclerAdapter(Context context, int itemHeight) {
        this.context = context;
        this.itemHeight = itemHeight;
    }

    @NonNull
    @Override
    public ImageListRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_image_list, parent, false);
        return new ImageListRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ImageListRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.itemView.setTag(position);
        holder.onBind(items.get(position));
        /*holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(context, FragmentActivity.class);
                intent.putExtra("title", "사진점검 리스트");
                intent.putExtra("type", "image_list_detail");
                intent.putExtra("value1", items.get(position).getCkIdx());
                context.startActivity(intent);
            }
        });*/
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<String> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        ImageView img;

        ItemViewHolder(View itemView) {
            super(itemView);
            img = itemView.findViewById(R.id.img);
            itemView.getLayoutParams().height = itemHeight / 8;
            //itemView.getLayoutParams().width = itemHeight / 5;
        }

        void onBind(String data) {
            try {
                Picasso picasso = new Picasso.Builder(context).listener(new Picasso.Listener() {
                    @Override
                    public void onImageLoadFailed(Picasso picasso, Uri uri, Exception exception) {
                        img.setImageResource(R.drawable.no_img);
                    }
                }).build();

                picasso.with(context).load(data).into(img);
            } catch (Exception e) {
                img.setImageResource(R.drawable.no_img);
            }

            itemView.setOnClickListener(itemClick);
        }
    }
}
