package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.PlanDetail.InvoiceData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;

public class InvoiceListAdapter extends RecyclerView.Adapter<InvoiceListAdapter.ItemViewHolder> {

    Context context;
    Handler handler;

    // adapter에 들어갈 list
    private ArrayList<InvoiceData> items = new ArrayList<>();

    public InvoiceListAdapter(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
    }

    @NonNull
    @Override
    public InvoiceListAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_invoice_list, viewGroup, false);
        return new InvoiceListAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull InvoiceListAdapter.ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));

        View.OnClickListener clickListener = new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (itemViewHolder.invoice_list_itemsRV.getVisibility() == View.VISIBLE) {
                    itemViewHolder.invoice_list_itemsRV.setVisibility(View.GONE);
                    itemViewHolder.invoice_detailIV.setImageResource(R.drawable.icon_arrow_down_gray2);

                } else {
                    itemViewHolder.invoice_list_itemsRV.setVisibility(View.VISIBLE);
                    itemViewHolder.invoice_detailIV.setImageResource(R.drawable.icon_arrow_up_gray);
                }
            }
        };
        itemViewHolder.invoice_list_itemsRV.setItemViewCacheSize(items.size());

        if (items.get(position).getItemList() != null) {
            itemViewHolder.adapter.addItem(items.get(position).getItemList());
            itemViewHolder.invoice_detailIV.setImageResource(R.drawable.icon_arrow_down_gray2);
            itemViewHolder.invoice_detailIV.setOnClickListener(clickListener);
        } else {
            itemViewHolder.invoice_detailIV.setImageDrawable(null);
        }
    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<InvoiceData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView invoice_dateTV, invoice_sumTV;
        ImageView invoice_detailIV;
        RecyclerView invoice_list_itemsRV;
        InvoiceListItemAdapter adapter;

        ItemViewHolder(View itemView) {
            super(itemView);

            invoice_dateTV = itemView.findViewById(R.id.invoice_dateTV);
            invoice_sumTV = itemView.findViewById(R.id.invoice_sumTV);
            invoice_detailIV = itemView.findViewById(R.id.invoice_detailIV);
            invoice_list_itemsRV = itemView.findViewById(R.id.invoice_list_itemsRV);

            adapter = new InvoiceListItemAdapter();
            invoice_list_itemsRV.setAdapter(adapter);

        }

        void onBind(InvoiceData data) {
            String ok_dt = (String) Common.getInstance().isNull(data.getOkDt());
            int price = 0;

            if (data.getItemSupply() != null) {
                price = Integer.parseInt(data.getItemSupply());
            }
            invoice_dateTV.setText(ok_dt.substring(0, 10));
            invoice_sumTV.setText(Common.getInstance().moneyFormatToWon(price) + "원");

        }
    }
}
