package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.PlanDetail.InvoiceData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;

public class InvoiceListItemAdapter extends RecyclerView.Adapter<InvoiceListItemAdapter.ItemViewHolder> {

    // adapter에 들어갈 list
    private ArrayList<InvoiceData> items = new ArrayList<>();

    public InvoiceListItemAdapter() {
    }

    @NonNull
    @Override
    public InvoiceListItemAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_invoice_list_items, viewGroup, false);
        return new InvoiceListItemAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull InvoiceListItemAdapter.ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));
    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<InvoiceData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView item_pd_nameTV, item_pd_sizeTV, item_supply_priceTV;

        ItemViewHolder(View itemView) {
            super(itemView);
            item_pd_nameTV = itemView.findViewById(R.id.item_pd_nameTV);
            item_pd_sizeTV = itemView.findViewById(R.id.item_pd_sizeTV);
            item_supply_priceTV = itemView.findViewById(R.id.item_supply_priceTV);
        }

        void onBind(InvoiceData data) {

            if (data.getPdCnt() != null) {
                String size = (String) Common.getInstance().isNull(data.getPdSize());
                String cnt = (String) Common.getInstance().isNull(data.getPdCnt());
                item_pd_sizeTV.setText(cnt +" "+ size);
            }

            if (data.getSupplyPrice() != null) {
                int price = Integer.parseInt(data.getSupplyPrice());
                item_supply_priceTV.setText(Common.getInstance().moneyFormatToWon(price)+"원");
            }

            item_pd_nameTV.setText(data.getPdName());
        }
    }
}
