package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.PlanDetail.Item;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;
import kr.co.compcareworker.Util.ItemTouchHelperAdapter;
import kr.co.compcareworker.Util.MyModifyClick;

public class InvoiceListRecyclerAdapter extends RecyclerView.Adapter<InvoiceListRecyclerAdapter.ItemViewHolder>
        implements ItemTouchHelperAdapter {

    Context context;
    Handler handler;
    MyModifyClick callback;

    // adapter에 들어갈 list
    private ArrayList<Item> items = new ArrayList<>();

    public InvoiceListRecyclerAdapter(Context context, Handler handler, MyModifyClick myModifyClick) {
        this.context = context;
        this.handler = handler;
        this.callback = myModifyClick;
    }

    @NonNull
    @Override
    public InvoiceListRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {

        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_invoice, viewGroup, false);

        return new ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull InvoiceListRecyclerAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        String index = "" + (position + 1);
//        items.get(position).setNum(index);
        itemViewHolder.invoice_modifyTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                callback.modifyClick(items.get(position));
            }
        });
    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<Item> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    public String getItemIndex(int position) {

        return items.get(position).getNum();
    }

    public String getItemPdId(int position) {

        return items.get(position).getIviIdx();
    }

    //    @Override
//    public void onItemMove(int fromPos, int targetPos) {
//
//        if(fromPos < targetPos){
//            for (int i = fromPos; i < targetPos; i++){
//                Collections.swap(items, i, i+1);
//            }
//        }else {
//            for (int i = fromPos; i > targetPos; i--){
//                Collections.swap(items, i, i-1);
//            }
//        }
//
//        notifyItemMoved(fromPos, targetPos);
//    }
//
    @Override
    public void onItemMove(int fromPos, int targetPos) {

        Item fromItem = items.get(fromPos);

        if (fromPos > targetPos) {

            items.remove(fromPos);
            items.add(targetPos, fromItem);

        } else {

            items.remove(fromPos);
            items.add(targetPos, fromItem);
        }

        notifyItemMoved(fromPos, targetPos);
        //notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView invoice_supply_priceTV, invoice_unit_priceTV, invoice_unitTV, invoice_amountTV,
                invoice_optionTV, invoice_nameTV, invoice_modifyTV;

        ImageView invoice_possessionIV;

        ItemViewHolder(View itemView) {
            super(itemView);

            invoice_modifyTV = itemView.findViewById(R.id.invoice_modifyTV);
            invoice_nameTV = itemView.findViewById(R.id.invoice_nameTV);
            invoice_optionTV = itemView.findViewById(R.id.invoice_optionTV);
            invoice_amountTV = itemView.findViewById(R.id.invoice_amountTV);
            invoice_unitTV = itemView.findViewById(R.id.invoice_unitTV);
            invoice_unit_priceTV = itemView.findViewById(R.id.invoice_unit_priceTV);
            invoice_supply_priceTV = itemView.findViewById(R.id.invoice_supply_priceTV);
            invoice_possessionIV = itemView.findViewById(R.id.invoice_possessionIV);

        }

        void onBind(Item data) {

            invoice_nameTV.setText(data.getPdName());
            invoice_optionTV.setText(data.getPdOption());
            invoice_amountTV.setText(data.getPdCnt());
            invoice_unitTV.setText(data.getPdSize());
            invoice_unit_priceTV.setText(Common.getInstance().moneyFormatToWon(Integer.parseInt(data.getPrice())));
            invoice_supply_priceTV.setText(Common.getInstance().moneyFormatToWon(Integer.parseInt(data.getSupplyPrice())));

        }
    }
}
