package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.net.URLEncoder;
import java.util.ArrayList;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Activity.WebviewAct;
import kr.co.compcareworker.Data.Company.CompanyData;
import kr.co.compcareworker.Data.Company.Machine.AlMachineDatum;
import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.R;

public class MachineListRecyclerAdapter extends RecyclerView.Adapter<MachineListRecyclerAdapter.ItemViewHolder> {
    Context context;
    String agency_id, user_id;

    public int showPosition = 0;
    boolean first = false;

    // adapter에 들어갈 list 입니다.
    private ArrayList<CompanyData> parentsItems = new ArrayList<>();
    private ArrayList<AlMachineDatum> items = new ArrayList<>();

    public MachineListRecyclerAdapter(Context context, String agency_id, String user_id) {
        this.context = context;
        this.agency_id = agency_id;
        this.user_id = user_id;
    }

    @NonNull
    @Override
    public MachineListRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_machine, parent, false);
        return new MachineListRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull MachineListRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));

        Animation animation = new AlphaAnimation(0, 1);
        animation.setDuration(1000);
        holder.subFrame.setAnimation(animation);

        if (showPosition == position) {
            if (holder.subFrame.getVisibility() == View.VISIBLE) {
                if (first) {
                    holder.subFrame.setVisibility(View.GONE);
                    holder.arrow.setImageResource(R.drawable.arrow_down);
                } else {
                    first = true;
                }
            } else {
                holder.subFrame.setVisibility(View.VISIBLE);
                holder.arrow.setImageResource(R.drawable.arrow_up);
            }
        } else {
            holder.subFrame.setVisibility(View.GONE);
            holder.arrow.setImageResource(R.drawable.arrow_down);
        }

        holder.arrowFrame.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (showPosition != position) {
                    showPosition = position;
                }

                notifyDataSetChanged();
            }
        });
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    /*public void addItem(ArrayList<AlMachineDatum> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        //items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }*/

    public void addItem(ArrayList<CompanyData> data) {
        for (int i = 0; i < data.size(); i++) {
            for (int j = 0; j < data.get(i).getAlMachineData().size(); j++) {
                items.add(data.get(i).getAlMachineData().get(j));
            }
        }

        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        ImageView add_qr, arrow, plus, qrPlus;
        TextView name, office, line, addr, time;
        LinearLayout subFrame, arrowFrame;
        RecyclerView list;
        MachineSubListRecyclerAdapter adapter;

        String pt_idx, cp_idx;

        ItemViewHolder(View itemView) {
            super(itemView);
            add_qr = itemView.findViewById(R.id.add_qr);
            arrow = itemView.findViewById(R.id.arrow);
            arrowFrame = itemView.findViewById(R.id.arrowFrame);
            plus = itemView.findViewById(R.id.plus);
            qrPlus = itemView.findViewById(R.id.qrPlus);
            name = itemView.findViewById(R.id.name);
            office = itemView.findViewById(R.id.office);
            addr = itemView.findViewById(R.id.addr);
            time = itemView.findViewById(R.id.time);
            line = itemView.findViewById(R.id.line);
            subFrame = itemView.findViewById(R.id.subFrame);
            list = itemView.findViewById(R.id.list);

            adapter = new MachineSubListRecyclerAdapter(context, agency_id, user_id);
            list.setAdapter(adapter);

            Animation animation = new AlphaAnimation(0, 1);
            animation.setDuration(1000);
            subFrame.setAnimation(animation);

            add_qr.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(context, FragmentActivity.class);
                    intent.putExtra("title", "QR코드 등록");
                    intent.putExtra("type", "qr");
                    intent.putExtra("value1", cp_idx);
                    intent.putExtra("value2", line.getText().toString());
                    context.startActivity(intent);
                }
            });

            qrPlus.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(context, FragmentActivity.class);
                    intent.putExtra("title", "QR코드 등록");
                    intent.putExtra("type", "qr");
                    intent.putExtra("value1", cp_idx);
                    intent.putExtra("value2", line.getText().toString());
                    context.startActivity(intent);
                }
            });

            plus.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String incodeUrl = URLEncoder.encode("https://" + agency_id + ".compcare.co.kr/setting/serial/write_machine/?cp_idx=" + cp_idx + "&pt_idx=" + pt_idx + "&mc_airline=" + line.getText().toString());
                    Intent intent = new Intent(context, WebviewAct.class);
                    intent.putExtra("title", "보유기종 관리");
                    intent.putExtra("url", "https://" + agency_id + ".compcare.co.kr/api/web/" + user_id + "/?url=" + incodeUrl);
                    context.startActivity(intent);
                }
            });
        }

        void onBind(AlMachineDatum data) {
            name.setText(data.getPt_name());
            office.setText(data.getCp_name());
            addr.setText(data.getCp_addr());
            time.setText(data.getCp_running_time() + "시간(주" + data.getCp_running_day() + "일)");

            line.setText(data.getMcAirline());

            ArrayList<MachineItem> item = new ArrayList<>();
            item.addAll(data.getItems());
            adapter.addItem(item);

            pt_idx = data.getPt_idx();
            cp_idx = data.getCp_idx();
        }
    }
}
