package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.util.ArrayList;

import kr.co.compcareworker.Data.Company.Machine.Product.MonitoringData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;
import kr.co.compcareworker.Util.ConvertTimeZone;

public class MonitoringRecyclerAdapter extends RecyclerView.Adapter<MonitoringRecyclerAdapter.ItemViewHolder> {

    Context context;
    String type;

    private ArrayList<MonitoringData> items = new ArrayList<>();

    public MonitoringRecyclerAdapter(Context context, String type) {
        this.context = context;
        this.type = type;
    }

    @NonNull
    @Override
    public MonitoringRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {

        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_monitoring, viewGroup, false);

        return new MonitoringRecyclerAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MonitoringRecyclerAdapter.ItemViewHolder itemViewHolder, int position) {

        try {
            itemViewHolder.onBind(items.get(position));
        } catch (ParseException e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<MonitoringData> data) {

        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void addItem(MonitoringData data) {

        items.add(data);
        notifyDataSetChanged();
    }

    class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView monitor_dateTV, monitor_valueTV;

        ItemViewHolder(View itemView) {
            super(itemView);

            monitor_dateTV = itemView.findViewById(R.id.monitor_dateTV);
            monitor_valueTV = itemView.findViewById(R.id.monitor_valueTV);
        }

        void onBind(MonitoringData data) throws ParseException {

            ConvertTimeZone timeZone = new ConvertTimeZone();
            String time;

            if (type.equals("day")) {
                time = timeZone.convertKoreaTime(data.getTime());

            } else if (type.equals("week") || type.equals("month")) {
                time = timeZone.convertKoreaTimeD(data.getTime());

            } else {
                time = timeZone.convertKoreaTimeS(data.getTime());
            }

            String set_data;

            if (data.getTempPt100() != null) {

                String temp_value = Common.getInstance().valueConvert(data.getTempPt100());
                set_data = "[" + temp_value + " ℃]";

            } else {
                set_data = "[ 없음 ]";
            }

            monitor_dateTV.setText(time);
            monitor_valueTV.setText(set_data);

        }
    }
}
