package kr.co.compcareworker.Util.Adapter;

import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ortiz.touchview.TouchImageView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Target;

import java.util.ArrayList;

import kr.co.compcareworker.R;

public class PlanImageRecyclerAdapter extends RecyclerView.Adapter<PlanImageRecyclerAdapter.ItemViewHolder> {


    Context context;
    int itemHeight;
    Handler handler;
    String type;

    public interface OnItemClickListener {
        void onItemClick(View v, int position);
    }

    private OnItemClickListener mListener = null;

    public void setOnItemClickListener(OnItemClickListener listener) {

        this.mListener = listener;
    }


    // adapter에 들어갈 list 입니다.
    public ArrayList<String> items = new ArrayList<>();
    public ArrayList<String> dataImgNo = new ArrayList<>();


    public PlanImageRecyclerAdapter(Context context, int itemHeight) {
        this.context = context;
        this.itemHeight = itemHeight;
    }

    public PlanImageRecyclerAdapter(Context context, Handler handler, int itemHeight) {
        this.context = context;
        this.handler = handler;
        this.itemHeight = itemHeight;
    }

    public PlanImageRecyclerAdapter(Context context, int itemHeight, String type, String type2) {
        this.context = context;
        this.itemHeight = itemHeight;
        this.type = type;
    }

    @NonNull
    @Override
    public PlanImageRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_plan_image, parent, false);
        return new PlanImageRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull PlanImageRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));

    }


    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addMoreItem(ArrayList<String> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void addItem(ArrayList<String> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void removeItem(int position) {
        items.remove(position);
        if (dataImgNo.size() > position) {
            dataImgNo.remove(position);
        }
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }


    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        ImageView img;
        Button remove;

        ItemViewHolder(View itemView) {
            super(itemView);
            img = itemView.findViewById(R.id.img);
            remove = itemView.findViewById(R.id.remove);
            remove.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int pos = getAdapterPosition();
                    if (pos != RecyclerView.NO_POSITION) {
                        // 리스너 객체의 메서드 호출.
                        if (mListener != null) {
                            mListener.onItemClick(v, pos);
                        }
                    }
                }
            });
            if (!TextUtils.isEmpty(type)) {
                remove.setVisibility(View.GONE);
            }
        }

        void onBind(String data) {
            itemView.getLayoutParams().height = itemHeight / 4;
            //itemView.getLayoutParams().height = itemView.getLayoutParams().width;
            GradientDrawable drawable = (GradientDrawable) context.getDrawable(R.drawable.border_black_round);
            img.setBackground(drawable);
            img.setClipToOutline(true);

            try {
                Picasso picasso = new Picasso.Builder(context).listener(new Picasso.Listener() {
                    @Override
                    public void onImageLoadFailed(Picasso picasso, Uri uri, Exception exception) {
                        img.setImageResource(R.drawable.no_img);
                    }
                }).build();

                picasso.with(context).load(data).into(img);
            } catch (Exception e) {
                img.setImageResource(R.drawable.no_img);
            }

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    RequestCreator picasso = Picasso.with(context).load(data);
                    try {
                        picasso.into(new Target() {
                            @Override
                            public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                                AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(context);
                                View view = LayoutInflater.from(context).inflate(R.layout.dlg_image, null);
                                TouchImageView iv = view.findViewById(R.id.imageview);
                                iv.setImageBitmap(bitmap);
                                dialogBuilder.setView(view);
                                dialogBuilder.show();
                            }

                            @Override
                            public void onBitmapFailed(Drawable errorDrawable) {

                            }

                            @Override
                            public void onPrepareLoad(Drawable placeHolderDrawable) {

                            }
                        });
                    } catch (Exception e) {

                    }
                }
            });
        }
    }
}
