package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.PlanDetail.ItemDatum;
import kr.co.compcareworker.R;

public class ProductRecyclerAdapter extends RecyclerView.Adapter<ProductRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;

    // adapter에 들어갈 list 입니다.
    private ArrayList<ItemDatum> items = new ArrayList<>();

    public ProductRecyclerAdapter(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
    }

    @NonNull
    @Override
    public ProductRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_product, parent, false);
        return new ProductRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ProductRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        //holder.onBind(items.get(position));
        ItemDatum data = items.get(position);

        if (data.getMcName().equals("")) {
            holder.mcName.setText("기타");
        } else {
            holder.mcName.setText(data.getMcName());
        }

        if (data.getItems().size() != 0) {
            holder.itemFrame.removeAllViews();
            for (int i = 0; i < data.getItems().size(); i++) {
                LinearLayout layout = new LinearLayout(context);
                TextView name = new TextView(context);
                TextView count = new TextView(context);
                TextView unit = new TextView(context);

                LinearLayout.LayoutParams layoutParam = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
                LinearLayout.LayoutParams nameParam = new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.WRAP_CONTENT);
                LinearLayout.LayoutParams countParam = new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.WRAP_CONTENT);
                LinearLayout.LayoutParams unitParam = new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.WRAP_CONTENT);

                layout.setOrientation(LinearLayout.HORIZONTAL);
                layout.setLayoutParams(layoutParam);

                nameParam.weight = 4;
                countParam.weight = 1;
                unitParam.weight = 1;

                nameParam.gravity = Gravity.CENTER;
                countParam.gravity = Gravity.CENTER;
                unitParam.gravity = Gravity.CENTER;

                name.setText(data.getItems().get(i).getPdName());
                name.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14f);
                name.setLayoutParams(nameParam);

                count.setText(data.getItems().get(i).getPdCnt());
                count.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14f);
                count.setLayoutParams(countParam);

                unit.setText(data.getItems().get(i).getPdSize());
                unit.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14f);
                unit.setLayoutParams(unitParam);

                layout.addView(name);
                layout.addView(count);
                layout.addView(unit);
                holder.itemFrame.addView(layout);
            }
        }
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<ItemDatum> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView mcName;
        LinearLayout itemFrame;

        ItemViewHolder(View itemView) {
            super(itemView);
            mcName = itemView.findViewById(R.id.mcName);
            itemFrame = itemView.findViewById(R.id.itemFrame);
        }
    }
}
