package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.Company.Machine.Product.ProductData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.MyProductClick;

public class ProductSearchRecyclerAdapter extends RecyclerView.Adapter<ProductSearchRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;
    MyProductClick callback;
    LinearLayout selectLL;

    private SparseBooleanArray mSelectedItems = new SparseBooleanArray(0);

    // adapter에 들어갈 list 입니다.
    private ArrayList<ProductData> items = new ArrayList<>();

    public ProductSearchRecyclerAdapter(Context context, Handler handler, MyProductClick myProductClick) {
        this.context = context;
        this.handler = handler;
        this.callback = myProductClick;
    }

    @NonNull
    @Override
    public ProductSearchRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {

        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_product_search, viewGroup, false);

        return new ProductSearchRecyclerAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ProductSearchRecyclerAdapter.ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));

        itemViewHolder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                selectLL = itemViewHolder.product_search_itemLL;
                itemViewHolder.itemView.setBackgroundResource(R.drawable.border_black_fill_yellow);

                callback.myProductClick(items.get(position));

            }
        });

    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<ProductData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    public void clearFocus() {

        selectLL.setBackgroundResource(R.drawable.border_black);

    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView pd_nameTV, pd_optionTV, pd_codeTV, pd_buyerTV;
        LinearLayout product_search_itemLL;
        ImageView pd_photo_existIV;

        ItemViewHolder(View itemView) {
            super(itemView);
            pd_codeTV = itemView.findViewById(R.id.pd_codeTV);
            pd_nameTV = itemView.findViewById(R.id.pd_nameTV);
            pd_optionTV = itemView.findViewById(R.id.pd_optionTV);
            pd_photo_existIV = itemView.findViewById(R.id.pd_photo_existIV);
            pd_buyerTV = itemView.findViewById(R.id.pd_buyerTV);
            product_search_itemLL = itemView.findViewById(R.id.product_search_itemLL);

        }

        void onBind(ProductData data) {

            pd_codeTV.setText(data.getPdCode());
            pd_nameTV.setText(data.getPdShortName());
            pd_optionTV.setText(data.getPdSpec());
            pd_buyerTV.setText(data.getPdBuyer());

            if (data.getPhoto1() != null) {

                pd_photo_existIV.setImageResource(R.drawable.icon_ok);

            } else {

                pd_photo_existIV.setImageResource(R.drawable.icon_no);
            }
        }
    }
}
