package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import kr.co.compcareworker.Data.EstimateList.QuicksetData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.MyOnItemClick;

public class QuickSetRecyclerAdapter extends RecyclerView.Adapter<QuickSetRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;
    MyOnItemClick callback;

    // adapter에 들어갈 list 입니다.
    private ArrayList<QuicksetData> items = new ArrayList<>();

    public QuickSetRecyclerAdapter(Context context, Handler handler, MyOnItemClick listener) {
        this.context = context;
        this.handler = handler;
        this.callback = listener;
    }

    @NonNull
    @Override
    public QuickSetRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_quickset, viewGroup, false);

        return new QuickSetRecyclerAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull QuickSetRecyclerAdapter.ItemViewHolder itemViewHolder, int position) {
        try {
            itemViewHolder.onBind(items.get(position));
        } catch (ParseException e) {
            e.printStackTrace();
        }

        int index = position + 1;
        itemViewHolder.quick_indexTV.setText("" + index);

        itemViewHolder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Bundle bundle = new Bundle();

                bundle.putString("qs_idx", items.get(position).getQsIdx());

                callback.onClick(bundle);
            }
        });

    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<QuicksetData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView quick_indexTV, quick_titleTV, quick_contentTV, quick_dateTV;

        ItemViewHolder(View itemView) {
            super(itemView);
            quick_indexTV = itemView.findViewById(R.id.quick_indexTV);
            quick_titleTV = itemView.findViewById(R.id.quick_titleTV);
            quick_contentTV = itemView.findViewById(R.id.quick_contentTV);
            quick_dateTV = itemView.findViewById(R.id.quick_dateTV);

        }

        void onBind(QuicksetData data) throws ParseException {

            quick_titleTV.setText(data.getQsTitle());
            quick_contentTV.setText(data.getQsContent());

            SimpleDateFormat beforeSDF = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date beforeDate = beforeSDF.parse(data.getInsDt());
            SimpleDateFormat afterSDF = new SimpleDateFormat("yyyy.MM.dd");
            String afterDate = afterSDF.format(beforeDate);

            quick_dateTV.setText(afterDate);

        }
    }
}
