package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.Search.SearchData;
import kr.co.compcareworker.R;

public class SearchRecyclerAdapter extends RecyclerView.Adapter<SearchRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;

    // adapter에 들어갈 list 입니다.
    private ArrayList<SearchData> items = new ArrayList<>();

    public SearchRecyclerAdapter(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
    }

    @NonNull
    @Override
    public SearchRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_search, parent, false);
        return new SearchRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull SearchRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<SearchData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView name, addr, ceo, tel;
        String cp_idx;

        ItemViewHolder(View itemView) {
            super(itemView);
            name = itemView.findViewById(R.id.name);
            addr = itemView.findViewById(R.id.addr);
            ceo = itemView.findViewById(R.id.ceo);
            tel = itemView.findViewById(R.id.tel);

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(context, FragmentActivity.class);
                    intent.putExtra("title", "설치장소 정보");
                    intent.putExtra("type", "enterprise");
                    intent.putExtra("value1", cp_idx);
                    context.startActivity(intent);
                }
            });
        }

        void onBind(SearchData data) {
            name.setText(data.getPtName());
            addr.setText(data.getCpAddr());
            ceo.setText(data.getPtCeo());
            tel.setText(data.getPtTel());

            cp_idx = data.getCpIdx();
        }
    }
}
