package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import kr.co.compcareworker.Data.ServiceList.ServiceImageData;
import kr.co.compcareworker.R;

public class ServiceImageRecylerAdapter extends RecyclerView.Adapter<ServiceImageRecylerAdapter.ItemViewHolder> {

    Context context;

    private ArrayList<ServiceImageData> items = new ArrayList<>();


    public ServiceImageRecylerAdapter(Context context) {
        this.context = context;
    }


    @NonNull
    @Override
    public ServiceImageRecylerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_service_image, parent, false);
        return new ServiceImageRecylerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ServiceImageRecylerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));

    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<ServiceImageData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }


    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView service_dateTV, service_engineerTV, service_cpnameTV, service_cunameTV, service_orderTV;
        RecyclerView service_imgRV;
        ServiceImageGridAdapter adapter;


        ItemViewHolder(View itemView) {
            super(itemView);
            service_dateTV = itemView.findViewById(R.id.service_dateTV);
            service_engineerTV = itemView.findViewById(R.id.service_engineerTV);
            service_cpnameTV = itemView.findViewById(R.id.service_cpnameTV);
            service_cunameTV = itemView.findViewById(R.id.service_cunameTV);
            service_orderTV = itemView.findViewById(R.id.service_orderTV);
            service_imgRV = itemView.findViewById(R.id.service_imgRV);
            service_imgRV.setLayoutManager(new GridLayoutManager(context, 5));
            adapter = new ServiceImageGridAdapter(context);
            service_imgRV.setAdapter(adapter);

        }

        void onBind(ServiceImageData data) {

            SimpleDateFormat beforeSDF = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date beforeDate = null;
            try {
                beforeDate = beforeSDF.parse(data.getWoSucdt());
            } catch (ParseException e) {
                e.printStackTrace();
            }
            SimpleDateFormat afterSDF = new SimpleDateFormat("yyyy.MM.dd HH:mm");
            String afterDate = afterSDF.format(beforeDate);

            service_dateTV.setText(afterDate);

            if (data.getWrWorkerName() != null && !data.getWrWorkerName().equals("0") && !data.getWrWorkerName().equals("")) {
                service_engineerTV.setText(data.getWrWorkerName());

            } else if (data.getWrWorkerName2() != null && !data.getWrWorkerName2().equals("0") && !data.getWrWorkerName2().equals("")) {
                service_engineerTV.setText(data.getWrWorkerName2());

            } else if (data.getWrWorkerName() != null && data.getWrWorkerName().equals("0") && !data.getWrWorkerName().equals("")) {
                service_engineerTV.setText("박철");

            } else if (data.getWrWorkerName2() != null && data.getWrWorkerName2().equals("0") && !data.getWrWorkerName2().equals("")) {
                service_engineerTV.setText("박철");

            } else {
                service_engineerTV.setText("");
            }

            service_cpnameTV.setText(data.getCpName());
            service_cunameTV.setText(data.getCuName());
            service_orderTV.setText(data.getWoMemo());

            adapter = new ServiceImageGridAdapter(context);
            service_imgRV.setLayoutManager(new GridLayoutManager(context, 5));
            adapter.addItem(data.getFileDatum());
            service_imgRV.setAdapter(adapter);

        }
    }
}


