package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.ArrayList;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.ServiceList.ServiceData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;

public class ServiceListRecyclerAdapter extends RecyclerView.Adapter<ServiceListRecyclerAdapter.ItemViewHolder> {
    Context context;
    public String pt_name;
    public String cp_idx;

    // adapter에 들어갈 list 입니다.
    private ArrayList<ServiceData> items = new ArrayList<>();

    public ServiceListRecyclerAdapter(Context context) {
        this.context = context;
    }

    @NonNull
    @Override
    public ServiceListRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_service, parent, false);
        return new ServiceListRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ServiceListRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));

    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<ServiceData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        ImageView img;
        TextView name, office, line, money, endDt, toMan, contents;
        String wo_idx;

        ItemViewHolder(View itemView) {
            super(itemView);
            img = itemView.findViewById(R.id.img);
            name = itemView.findViewById(R.id.name);
            office = itemView.findViewById(R.id.office);
            line = itemView.findViewById(R.id.line);
            money = itemView.findViewById(R.id.money);
            endDt = itemView.findViewById(R.id.endDt);
            toMan = itemView.findViewById(R.id.toMan);
            contents = itemView.findViewById(R.id.contents);
        }

        void onBind(ServiceData data) {
            try {
                Picasso picasso = new Picasso.Builder(context).listener(new Picasso.Listener() {
                    @Override
                    public void onImageLoadFailed(Picasso picasso, Uri uri, Exception exception) {
                        img.setImageResource(R.drawable.no_img);
                    }
                }).build();

                picasso.with(context).load(data.getFileAfter().get(0).getUrl()).into(img);
            } catch (Exception e) {
                img.setImageResource(R.drawable.no_img);
            }

            name.setText(pt_name);
            office.setText(data.getCpName());
            line.setText(data.getCpAirline());
            if (data.getWrEnddtDay() != null) {
                endDt.setText(data.getWrEnddtDay());
            } else {
                if (data.getWrStatusStr() != null) {
                    endDt.setText(data.getWrStatusStr().toString());
                } else {
                    endDt.setText("");
                }
            }

            money.setText(Common.getInstance().moneyFormatToWon(Integer.parseInt(data.getEsPrice())) + "원");

            toMan.setText(data.getWrWorkerName());
            contents.setText(data.getWrMemoReport());

            wo_idx = data.getWoIdx();

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(context, FragmentActivity.class);
                    intent.putExtra("title", "서비스 상세보기");
                    intent.putExtra("type", "service_detail");
                    intent.putExtra("value1", data.getWrIdx());
                    intent.putExtra("value2", cp_idx);
                    intent.putExtra("value3", line.getText().toString());
                    context.startActivity(intent);

                    if (data.getFileBefore() != null)
                        Common.getInstance().currentServiceBeforeImage.addAll(data.getFileBefore());
                    if (data.getFileAfter() != null)
                        Common.getInstance().currentServiceAfterImage.addAll(data.getFileAfter());
                }
            });
        }
    }
}
