package kr.co.compcareworker.Util.Adapter;

import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import kr.co.compcareworker.Data.Company.Machine.AlMachineDatum;
import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.Data.MainViewList.SubProdData;
import kr.co.compcareworker.R;

public class SubProdListDetailAdapter extends RecyclerView.Adapter<SubProdListDetailAdapter.ItemViewHolder> {

    // adapter에 들어갈 list 입니다.
    private ArrayList<MachineItem> items = new ArrayList<>();

    private SubProdListDetailAdapter.resetListener resetListener;

    public interface resetListener {
        void onClick(MachineItem data);
    }

    public SubProdListDetailAdapter(SubProdListDetailAdapter.resetListener resetListener) {
        this.resetListener = resetListener;
    }

    @NonNull
    @Override
    public SubProdListDetailAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_subprod_list_detail_view, parent, false);
        return new SubProdListDetailAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull SubProdListDetailAdapter.ItemViewHolder holder, int position) {
        holder.onBind(items.get(position));

        holder.machine_resetTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                resetListener.onClick(items.get(position));
            }
        });

        if(position > 0) {
            holder.divideTV.setVisibility(View.VISIBLE);
        }
    }

    public void addAll(ArrayList<MachineItem> lst) {
        items.clear();
        items.addAll(lst);
        notifyDataSetChanged();
    }

    public void addItem(MachineItem lst) {
        items.clear();
        items.add(lst);
        notifyDataSetChanged();
    }

    public void addItemMore(ArrayList<MachineItem> lst) {
        items.addAll(lst);
        notifyItemRangeChanged(0, items.size());
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView exchange_timeTV, pd_nameTV, running_timeTV, divideTV, macTV, machine_resetTV;

        ItemViewHolder(View itemView) {
            super(itemView);
            exchange_timeTV = itemView.findViewById(R.id.exchange_timeTV);
            machine_resetTV = itemView.findViewById(R.id.machine_resetTV);
            pd_nameTV = itemView.findViewById(R.id.pd_nameTV);
            running_timeTV = itemView.findViewById(R.id.running_timeTV);
            divideTV = itemView.findViewById(R.id.divideTV);
            macTV = itemView.findViewById(R.id.macTV);
        }

        void onBind(MachineItem data) {

            pd_nameTV.setText(data.getPdName());
            exchange_timeTV.setText("( 교환일 : - / 예정일 : - )");
            running_timeTV.setText("(소모품 시간 : - )");

            Calendar cal = Calendar.getInstance();
            DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date date = null;

            if (data.getMcIotMac() != null) {
                macTV.setText("MAC : "+data.getMcIotMac());

                if(data.getMcRunningtime() != null && data.getMcCycle() != null) {

                    running_timeTV.setText("( 소모품 시간 : "+data.getMcRunningtime()+" / "+data.getMcCycle()+" )");

                    if(Integer.parseInt(data.getMcRunningtime()) >= Integer.parseInt(data.getMcCycle())) {
                        running_timeTV.setTextColor(Color.RED);
                    }

                    if (data.getMcExchangedt() != null) {
                        try {
                            date = df.parse(data.getMcExchangedt().toString());
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                        cal.setTime(date);
                        if (data.getMcCycleYear() != null) {
                            cal.set(Calendar.YEAR, cal.get(Calendar.YEAR));
                            cal.set(Calendar.MONTH, cal.get(Calendar.MONTH) + Integer.parseInt(data.getMcCycleYear()));
                            exchange_timeTV.setText("( 교환일 : "+data.getMcExchangedt().toString()+" / 예정일 : "+df.format(cal.getTime()) +" )");

                        } else {
                            exchange_timeTV.setText("(교환일 : "+data.getMcExchangedt().toString()+" / 예정일 : - )");
                        }
                    }
                }

            } else {

                macTV.setText("MAC : 없음");
                if (data.getMcExchangedt() != null) {
                    try {
                        date = df.parse(data.getMcExchangedt().toString());
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    cal.setTime(date);

                    if (data.getMcCycleYear() != null) {
                        cal.set(Calendar.YEAR, cal.get(Calendar.YEAR));
                        cal.set(Calendar.MONTH, cal.get(Calendar.MONTH) + Integer.parseInt(data.getMcCycleYear()));
                        exchange_timeTV.setText("( 교환일 : "+data.getMcExchangedt().toString()+" / 예정일 : "+df.format(cal.getTime()) +" )");

                    } else {
                        exchange_timeTV.setText("(교환일 : "+data.getMcExchangedt().toString()+" / 예정일 : - )");
                    }

                }

                if(data.getMcRunningtime() != null && data.getMcCycle() != null) {

                    running_timeTV.setText("( 소모품 시간 : "+data.getMcRunningtime()+" / "+data.getMcCycle()+" )");

                    if (Integer.parseInt(data.getMcRunningtime()) >= Integer.parseInt(data.getMcCycle())) {
                        running_timeTV.setTextColor(Color.RED);
                    }
                }
            }
        }
    }
}

