package kr.co.compcareworker.Util.Adapter;

import android.app.Activity;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.Data.MainViewList.SubProdData;
import kr.co.compcareworker.R;


public class SubProdRecyclerAdapter extends RecyclerView.Adapter<SubProdRecyclerAdapter.ItemViewHolder> {

    private Activity activity;
    Handler handler;
    // adapter에 들어갈 list 입니다.
    private ArrayList<SubProdData> items = new ArrayList<>();

    private OnLoadMoreListener onLoadMoreListener;

    public interface OnLoadMoreListener {
        void onLoadMore(int position);
    }

    private SubProdRecyclerAdapter.OnClickListener onClickListener;

    public interface OnClickListener {
        void onClick(String x, String y, String cp_idx, String pt_idx, String cp_zip);
    }

    private SubProdRecyclerAdapter.resetListener resetListener;

    public interface resetListener {
        void onClick(MachineItem data);
    }

    private SubProdRecyclerAdapter.enterpriseListener enterpriseListener;

    public interface enterpriseListener {
        void onClick(SubProdData data);
    }

    public SubProdRecyclerAdapter(Activity activity, Handler handler, OnLoadMoreListener onLoadMoreListener, SubProdRecyclerAdapter.OnClickListener onClickListener,
                                  SubProdRecyclerAdapter.resetListener resetListener, SubProdRecyclerAdapter.enterpriseListener enterpriseListener) {
        this.onLoadMoreListener = onLoadMoreListener;
        this.onClickListener = onClickListener;
        this.activity = activity;
        this.handler = handler;
        this.resetListener = resetListener;
        this.enterpriseListener = enterpriseListener;
    }

    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_subprod_list, parent, false);
        return new SubProdRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ItemViewHolder holder, int position) {
        holder.onBind(items.get(position));
        holder.adapter = new SubProdListAdapter(activity, new SubProdListAdapter.resetListener() {
            @Override
            public void onClick(MachineItem data) {
                resetListener.onClick(data);
            }
        }, new SubProdListAdapter.enterpriseListener() {
            @Override
            public void onClick(MachineItem data) {
                enterpriseListener.onClick(items.get(position));
            }
        });
        holder.adapter.addAll(items.get(position).getMachineItems());
        holder.subprod_listRV.setAdapter(holder.adapter);

        holder.enterpriseTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                enterpriseListener.onClick(items.get(position));
            }
        });

        if (position == getItemCount() - 1) {
            if (onLoadMoreListener != null) {
                onLoadMoreListener.onLoadMore(position);
            }
        }

        holder.cp_infoLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onClickListener.onClick(items.get(position).getCpMapx(), items.get(position).getCpMapy(), items.get(position).getCpIdx(),  items.get(position).getPtIdx(), items.get(position).getCpZip());
            }
        });
    }

    public void addAll(ArrayList<SubProdData> lst) {
        items.clear();
        items.addAll(lst);
        notifyDataSetChanged();
    }

    public void addItemMore(ArrayList<SubProdData> lst) {
        items.addAll(lst);
        notifyItemRangeChanged(0, items.size());
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView name, enterpriseTV, cp_name, regionTV;
        String cp_idx;
        RecyclerView subprod_listRV;
        SubProdListAdapter adapter;
        LinearLayout cp_infoLL;

        ItemViewHolder(View itemView) {
            super(itemView);
            name = itemView.findViewById(R.id.name);
            subprod_listRV = itemView.findViewById(R.id.subprod_listRV);
            enterpriseTV = itemView.findViewById(R.id.enterpriseTV);
            cp_name = itemView.findViewById(R.id.cp_name);
            regionTV = itemView.findViewById(R.id.regionTV);
            cp_infoLL = itemView.findViewById(R.id.cp_infoLL);
        }

        void onBind(SubProdData data) {
            name.setText(data.getPtName());
            cp_name.setText(" [ " + data.getCpName() + " ]");
            if(data.getCpSido() != null && data.getCpSigungu() != null) {
                String sigungu = data.getCpSigungu();
                if(sigungu.contains(" ")) {
                    sigungu = sigungu.substring(0, sigungu.indexOf(" "));
                }
                regionTV.setText(data.getCpSido() + " " + sigungu);
            } else {
                regionTV.setText("주소 없음");
            }
            cp_idx = data.getCpIdx();
        }
    }
}
