package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import kr.co.compcareworker.Data.PlanDetail.InvoiceData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.MyOnItemClick;

public class TransactionRecyclerAdapter extends RecyclerView.Adapter<TransactionRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;
    MyOnItemClick callback;

    // adapter에 들어갈 list 입니다.
    private ArrayList<InvoiceData> items = new ArrayList<>();

    public TransactionRecyclerAdapter(Context context, Handler handler, MyOnItemClick listener) {
        this.context = context;
        this.handler = handler;
        this.callback = listener;
    }

    @NonNull
    @Override
    public TransactionRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_transation, viewGroup, false);

        return new TransactionRecyclerAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull TransactionRecyclerAdapter.ItemViewHolder itemViewHolder, int position) {

        try {
            itemViewHolder.onBind(items.get(position));
        } catch (ParseException e) {
            e.printStackTrace();
        }

        itemViewHolder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Bundle bundle = new Bundle();

                bundle.putString("iv_idx", items.get(position).getIvIdx());

                callback.onClick(bundle);
            }
        });

    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<InvoiceData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView transaction_clientTV, transaction_productTV, transaction_priceTV, transaction_dateTV;

        ItemViewHolder(View itemView) {
            super(itemView);
            transaction_clientTV = itemView.findViewById(R.id.transaction_clientTV);
            transaction_productTV = itemView.findViewById(R.id.transaction_productTV);
            transaction_priceTV = itemView.findViewById(R.id.transaction_priceTV);
            transaction_dateTV = itemView.findViewById(R.id.transaction_dateTV);

        }

        void onBind(InvoiceData data) throws ParseException {

            transaction_clientTV.setText(data.getCuName());
            transaction_productTV.setText(data.getPdName());
            transaction_priceTV.setText(data.getEsPrice());

            SimpleDateFormat beforeSDF = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date beforeDate = beforeSDF.parse(data.getInsDt());
            SimpleDateFormat afterSDF = new SimpleDateFormat("yyyy.MM.dd");
            String afterDate = afterSDF.format(beforeDate);

            transaction_dateTV.setText(afterDate);

        }
    }
}
