package kr.co.compcareworker.Util.Adapter;

import android.app.Activity;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.MainViewList.WorkerListData;
import kr.co.compcareworker.R;


public class WorkerListRecyclerAdapter extends RecyclerView.Adapter<WorkerListRecyclerAdapter.ItemViewHolder> {

    private Activity activity;
    Handler handler;
    // adapter에 들어갈 list 입니다.
    private ArrayList<WorkerListData> items = new ArrayList<>();

    private OnLoadMoreListener onLoadMoreListener;
    public View.OnClickListener itemClick;
    public View.OnClickListener callListClick;
    String pageType;

    public interface OnLoadMoreListener {
        void onLoadMore(int position);
    }

    public WorkerListRecyclerAdapter(Activity activity, Handler handler, OnLoadMoreListener onLoadMoreListener, String type) {
        this.onLoadMoreListener = onLoadMoreListener;
        this.activity = activity;
        this.handler = handler;
        this.pageType = type;
    }

    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_worker_list, parent, false);
        return new WorkerListRecyclerAdapter.ItemViewHolder(view);
    }

    public void addAll(ArrayList<WorkerListData> lst) {
        items.clear();
        items.addAll(lst);
        notifyDataSetChanged();
    }

    public void addItemMore(ArrayList<WorkerListData> lst) {
        items.addAll(lst);
        notifyItemRangeChanged(0, items.size());
        //notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public void onBindViewHolder(@NonNull WorkerListRecyclerAdapter.ItemViewHolder holder, int position) {
        holder.onBind(items.get(position));
        holder.main_cp_member_listIV.setTag(items.get(position).getPtIdx());
        holder.itemView.setTag(holder.wr_idx);
        holder.itemView.setOnClickListener(itemClick);
        holder.main_cp_member_listIV.setOnClickListener(callListClick);
        if (position == getItemCount() - 1) {
            if (onLoadMoreListener != null) {
                onLoadMoreListener.onLoadMore(position);
            }
        }
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView dt, tm, name, contents, type, nm;
        String wr_idx;
        ImageView photo_existIV, memo_existIV;

        ImageView main_cp_member_listIV;

        ItemViewHolder(View itemView) {
            super(itemView);
            dt = itemView.findViewById(R.id.dt);
            tm = itemView.findViewById(R.id.tm);
            name = itemView.findViewById(R.id.name);
            contents = itemView.findViewById(R.id.contents);
            type = itemView.findViewById(R.id.type);
            nm = itemView.findViewById(R.id.nm);
            photo_existIV = itemView.findViewById(R.id.photo_existIV);
            memo_existIV = itemView.findViewById(R.id.memo_existIV);

            main_cp_member_listIV = itemView.findViewById(R.id.main_cp_member_listIV);
        }

        void onBind(WorkerListData data) {

            if (data.getWrPhotoCnt() != null && Integer.parseInt(data.getWrPhotoCnt()) > 0) {
                photo_existIV.setVisibility(View.VISIBLE);
            } else {
                photo_existIV.setVisibility(View.GONE);
            }

            if (data.getWrMemoReport() != null && !data.getWrMemoReport().equals("")) {
                memo_existIV.setVisibility(View.VISIBLE);
            } else {
                memo_existIV.setVisibility(View.GONE);
            }

            dt.setText(data.getWrStartdtDay());
            tm.setText(data.getWrStartdtTime());
            name.setText(data.getCuName());
            if (pageType.equals("service")) {
                if (data.getWrMemoReport() != null) {
                    contents.setText(data.getWrMemoReport());
                }
            } else {
                contents.setText(data.getWrMemoOrders());
            }

            nm.setText(data.getWrWorkerName());

            if (data.getWrCheck().equals("Y")) {
                type.setBackgroundResource(R.drawable.border_red_round);
                type.setTextColor(activity.getResources().getColor(R.color.red));
                type.setText("기사배정");

            } else {
                type.setText(data.getWrStatusStr());
            }
            /*if (type.getText().toString().equals("작업완료")){
                type.setBackgroundResource(R.drawable.border_main_fill_main_round);
                type.setTextColor(activity.getResources().getColor(R.color.white));
            }else{
                type.setBackgroundResource(R.drawable.border_main_round);
                type.setTextColor(activity.getResources().getColor(R.color.color_main));
            }*/

            wr_idx = data.getWrIdx();
        }
    }
}
