package kr.co.compcareworker.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.ArraySet;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.util.Arrays;
import java.util.HashMap;

import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Api.ApiClient;
import kr.co.compcareworker.Util.Common;

public class AddAirLineDialog extends Dialog {

    Context context;
    private String cp_idx, old_airline, match_airline;
    private Handler hdr;
    private Spinner dlg_air_line_selectSN;
    private TextView dlg_air_line_saveTV;
    private EditText dlg_air_line_nameET;
    private String[] air_line_array;
    private ArraySet<String> air_line_set;
    private ArrayAdapter<String> air_line_adapter;
    private int select_position = 0;

    private AddAirLineDialog.clickListener clickListener;

    public interface clickListener {
        void clickBtn(HashMap<String, String> data);
    }

    public AddAirLineDialog(@NonNull Context context, Handler hdr, String cp_idx, String[] air_line_array, AddAirLineDialog.clickListener clickListener) {
        super(context);
        this.context = context;
        this.hdr = hdr;
        this.cp_idx = cp_idx;
        this.air_line_array = air_line_array;
        this.clickListener = clickListener;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_add_air_line);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        dlg_air_line_selectSN = findViewById(R.id.dlg_air_line_selectSN);
        dlg_air_line_nameET = findViewById(R.id.dlg_air_line_nameET);
        dlg_air_line_saveTV = findViewById(R.id.dlg_air_line_saveTV);

        air_line_set = new ArraySet<>();

        //에어라인 스피너 초기화
        air_line_adapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_spinner_dropdown_item);
        air_line_adapter.add("라인 추가");
        for (String s : air_line_array) {
            air_line_adapter.add(s);
        }
        dlg_air_line_selectSN.setAdapter(air_line_adapter);

        init_Handler();
        init_Listener();
    }

    void init_Listener() {

        //선택한 Air_Line
        dlg_air_line_selectSN.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {

                if (position > 0) {
                    select_position = position - 1;
                    old_airline = dlg_air_line_selectSN.getSelectedItem().toString();
                    dlg_air_line_nameET.setText(old_airline);

                } else {
                    select_position = air_line_array.length;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

        dlg_air_line_saveTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (dlg_air_line_nameET.getText().toString().equals("")) {
                    Common.getInstance().toastShow(getContext(), "에어라인명을 입력하세요.");
                    return;
                }
                String air_line;

                HashMap<String, String> data = new HashMap<>();
                data.put("cp_idx", cp_idx);

                if (select_position < air_line_array.length) {
                    air_line_array[select_position] = dlg_air_line_nameET.getText().toString();
                    air_line_set.addAll(Arrays.asList(air_line_array));
                    air_line = Arrays.toString(air_line_set.toArray());
                    air_line = air_line.replace("[", "");
                    air_line = air_line.replace("]", "");
                    air_line = air_line.replace(", ", ",");
                    data.put("new_airline", dlg_air_line_nameET.getText().toString());
                    data.put("old_airline", old_airline);

                } else {
                    air_line_set.addAll(Arrays.asList(air_line_array));
                    air_line_set.add(dlg_air_line_nameET.getText().toString());
                    air_line = Arrays.toString(air_line_set.toArray());
                    air_line = air_line.replace("[", "");
                    air_line = air_line.replace("]", "");
                    air_line = air_line.replace(", ", ",");
                }

                match_airline = dlg_air_line_nameET.getText().toString();
                data.put("cp_airline", air_line);
                Log.d("데이터확인@@@@", data.toString());

                new ApiClient(data, "proc_admin_add_airline", hdr);
            }
        });
    }

    void init_Handler() {

        hdr = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                String url = msg.getData().getString("url");

                if (msg.what == 1) {

                    if (url.equals("proc_admin_add_airline")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();

                        if (result_item.get("resultItem").getAsJsonObject().get("result").getAsString().equals("Y")) {
                            Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();

                            for (int i = 0; i < air_line_set.size(); i++) {
                                if (air_line_set.valueAt(i).equals(match_airline)) {
                                    select_position = i;
                                }
                            }
                            HashMap<String, String> data = new HashMap<>();
                            data.put("air_position", select_position + "");
                            clickListener.clickBtn(data);
                            dismiss();

                        } else {
                            Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                            dismiss();
                        }
                    }

                } else if (msg.what == -1){
                    Toast.makeText(getContext(), msg.obj.toString(), Toast.LENGTH_SHORT).show();
                }
            }
        };
    }
}

