package kr.co.compcareworker.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import kr.co.compcareworker.R;

public class CustomDialog extends Dialog {

    private TextView title;
    private EditText contents;
    String memo;

    public String con;

    private CustomDialogListener customDialogListener;

    public CustomDialog(Context context, String memo, CustomDialogListener customDialogListener) {
        super(context);
        this.customDialogListener = customDialogListener;
        this.memo = memo;
    }

    public interface CustomDialogListener {
        void clickBtn(String data);
    }

    @Override
    protected void onCreate(Bundle saveInstanceState) {
        super.onCreate(saveInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_custom_memo);

        title = findViewById(R.id.title);
        title.setText("조치 결과");

        Button save = (Button) findViewById(R.id.save);
        contents = (EditText) findViewById(R.id.contents);
        contents.setText(memo);

        save.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                customDialogListener.clickBtn(contents.getText().toString());
                con = contents.getText().toString();

                dismiss();
            }
        });
    }
}
