package kr.co.compcareworker.Util.CustomView;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.ArrayItem;
import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Adapter.DlgMonitoringReportCompareAdapter;
import kr.co.compcareworker.Util.Common;

public class MonitoringReportDialog extends Dialog {

    private Context context;
    private Handler hdr;
    private Spinner select_monthSN, select_weekSN, select_yearSN;
    private RadioButton select_type_weekRB, select_type_monthRB, select_type_dateRB;
    private TextView select_cancelTV, select_confirmTV;
    private String year, month, week, type, cp_name;
    private int this_week, this_month, total_week;

    private TextView reportTV, compareTV, compare_start_dateTV, compare_end_dateTV, compare_ori_macTV;
    private LinearLayout reportLL, compareLL, compare_dateLL;
    private RecyclerView compare_mac_listRV;
    private boolean is_report = true;
    private ArrayItem<MachineItem> machineItem;
    private DatePickerDialog.OnDateSetListener callbackMethod, endCallbackMethod, report_callbackMethod, report_endCallbackMethod, day_CallbackMethod;
    private Calendar min_calendar;
    private ArrayList<String> mc_idx_list;
    private MachineItem ori_machine_data;

    private TextView compare_ori_cp_nameTV, compare_ori_airlineTV, compare_ori_pd_nameTV, report_start_dateTV, report_end_dateTV, report_regular_publishTV;
    private LinearLayout report_select_week_monthLL, report_select_dateLL;

    private LinearLayout report_select_dayLL;
    private TextView report_select_dayTV;
    private RadioButton select_type_dayRB;
    private Spinner report_start_timeSN, report_end_timeSN;
    private ArrayAdapter<CharSequence> start_adapter, end_adapter;
    private int start_time = 0, end_time = 23;
    private ArrayAdapter<String> year_adapter;
    private boolean init_week = false;

    public MonitoringReportDialog(@NonNull Context context, Handler hdr, MachineItem ori_machine_data, String cp_name, ArrayItem<MachineItem> machineItem) {
        super(context);
        this.context = context;
        this.hdr = hdr;
        this.ori_machine_data = ori_machine_data;
        this.cp_name = cp_name;
        this.machineItem = machineItem;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_monitoring_report);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        select_monthSN = findViewById(R.id.select_monthSN);
        select_weekSN = findViewById(R.id.select_weekSN);
        select_cancelTV = findViewById(R.id.select_cancelTV);
        select_confirmTV = findViewById(R.id.select_confirmTV);
        select_type_weekRB = findViewById(R.id.select_type_weekRB);
        select_type_monthRB = findViewById(R.id.select_type_monthRB);
        select_yearSN = findViewById(R.id.select_yearSN);

        reportTV = findViewById(R.id.reportTV);
        compareTV = findViewById(R.id.compareTV);
        compare_start_dateTV = findViewById(R.id.compare_start_dateTV);
        compare_end_dateTV = findViewById(R.id.compare_end_dateTV);
        compare_ori_macTV = findViewById(R.id.compare_ori_macTV);
        reportLL = findViewById(R.id.reportLL);
        compareLL = findViewById(R.id.compareLL);
        compare_mac_listRV = findViewById(R.id.compare_mac_listRV);
        compare_dateLL = findViewById(R.id.compare_dateLL);

        compare_ori_cp_nameTV = findViewById(R.id.compare_ori_cp_nameTV);
        compare_ori_airlineTV = findViewById(R.id.compare_ori_airlineTV);
        compare_ori_pd_nameTV = findViewById(R.id.compare_ori_pd_nameTV);
        select_type_dateRB = findViewById(R.id.select_type_dateRB);
        report_select_week_monthLL = findViewById(R.id.report_select_week_monthLL);
        report_select_dateLL = findViewById(R.id.report_select_dateLL);
        report_start_dateTV = findViewById(R.id.report_start_dateTV);
        report_end_dateTV = findViewById(R.id.report_end_dateTV);
        report_regular_publishTV = findViewById(R.id.report_regular_publishTV);

        report_select_dayLL = findViewById(R.id.report_select_dayLL);
        report_select_dayTV = findViewById(R.id.report_select_dayTV);
        select_type_dayRB = findViewById(R.id.select_type_dayRB);

        report_start_timeSN = findViewById(R.id.report_start_timeSN);
        report_end_timeSN = findViewById(R.id.report_end_timeSN);

        type = "day";

        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.KOREA);
        String today = dataFormat.format(calendar.getTime());
        report_select_dayTV.setText(today);

        //시작시간 스피너 초기화
        start_adapter = ArrayAdapter.createFromResource(getContext(), R.array.start_time, R.layout.custom_spinner_item_blue);
        start_adapter.setDropDownViewResource(R.layout.custom_spinner_item_blue);
        report_start_timeSN.setAdapter(start_adapter);

        //종료시간 스피너 초기화
        end_adapter = ArrayAdapter.createFromResource(getContext(), R.array.end_time, R.layout.custom_spinner_item_blue);
        end_adapter.setDropDownViewResource(R.layout.custom_spinner_item_blue);
        report_end_timeSN.setAdapter(end_adapter);

        report_start_timeSN.setSelection(0);
        report_end_timeSN.setSelection(23);

        this_week = calendar.get(Calendar.WEEK_OF_MONTH);
        this_month = calendar.get(Calendar.MONTH) + 1;
        int day = calendar.getActualMaximum(Calendar.DATE);
        calendar.set(calendar.get(Calendar.YEAR), this_month - 1, day);
        total_week = calendar.get(Calendar.WEEK_OF_MONTH);

        year = calendar.get(Calendar.YEAR) + "";
        month = this_month + "";

        //년도 스피너 초기화
        year_adapter = new ArrayAdapter<>(getContext(), R.layout.custom_spinner_item_black);

        for (int i = 2020; i <= calendar.get(Calendar.YEAR); i++) {
            year_adapter.add(i + "년");
        }

        select_yearSN.setOnItemSelectedListener(null);
        select_monthSN.setOnItemSelectedListener(null);
        select_yearSN.setAdapter(year_adapter);
        select_yearSN.setSelection(year_adapter.getCount() - 1);

        //월 스피너 초기화
        ArrayAdapter<CharSequence> month_adapter = ArrayAdapter.createFromResource(getContext(), R.array.month, R.layout.custom_spinner_item_blue);
        select_monthSN.setAdapter(month_adapter);
        select_monthSN.setSelection(this_month - 1);

        //주 스피너 초기화
        ArrayAdapter<CharSequence> week_adapter;
        if (total_week < 5) {
            week_adapter = ArrayAdapter.createFromResource(getContext(), R.array.select_week_4, R.layout.custom_spinner_item_black);
        } else if (total_week == 5) {
            week_adapter = ArrayAdapter.createFromResource(getContext(), R.array.select_week_5, R.layout.custom_spinner_item_black);
        } else {
            week_adapter = ArrayAdapter.createFromResource(getContext(), R.array.select_week_6, R.layout.custom_spinner_item_black);
        }

        select_weekSN.setSelection(this_week - 1);
        select_yearSN.setOnItemSelectedListener(year_listener);
        select_monthSN.setOnItemSelectedListener(month_listener);

        init_Listener();
    }

    void init_week() {

        Calendar calendar = Calendar.getInstance();
        int select_year = Integer.parseInt(year);
        int select_month = Integer.parseInt(month);
        calendar.set(select_year, select_month - 1, 1);
        int day = calendar.getActualMaximum(Calendar.DATE);
        calendar.set(select_year, select_month - 1, day);
        total_week = calendar.get(Calendar.WEEK_OF_MONTH);

        ArrayAdapter<CharSequence> week_adapter;
        if (total_week < 5) {
            week_adapter = ArrayAdapter.createFromResource(getContext(), R.array.select_week_4, R.layout.custom_spinner_item_black);
        } else if (total_week == 5) {
            week_adapter = ArrayAdapter.createFromResource(getContext(), R.array.select_week_5, R.layout.custom_spinner_item_black);
        } else {
            week_adapter = ArrayAdapter.createFromResource(getContext(), R.array.select_week_6, R.layout.custom_spinner_item_black);
        }

        select_weekSN.setAdapter(week_adapter);
        Log.d("뭔데요@@@@", init_week + "");
        if (!init_week) {
            select_weekSN.setSelection(this_week - 1);

        } else {
            select_weekSN.setSelection(0);
            init_week = false;
        }

    }

    AdapterView.OnItemSelectedListener year_listener = new AdapterView.OnItemSelectedListener() {
        @Override
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
            Log.d("year@@@@", "dddd");
            year = select_yearSN.getSelectedItem().toString();
            year = year.replace("년", "");
            select_monthSN.setSelection(0);
        }

        @Override
        public void onNothingSelected(AdapterView<?> parent) {
        }
    };

    AdapterView.OnItemSelectedListener month_listener = new AdapterView.OnItemSelectedListener() {
        @Override
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
            Log.d("month@@@@", "dddd");
            Calendar calendar = Calendar.getInstance();
            if (Integer.parseInt(year) == calendar.get(Calendar.YEAR) && position + 1 > this_month) {
                Common.getInstance().toastShow(context, "현재보다 미래의 일자는 선택할 수 없습니다.");
                select_monthSN.setSelection(this_month - 1);
            } else {
                month = (position + 1) + "";
                init_week();
            }
        }

        @Override
        public void onNothingSelected(AdapterView<?> parent) {
        }
    };

    void init_Listener() {

        //선택한 주차
        select_weekSN.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                Calendar calendar = Calendar.getInstance();
                if ((Integer.parseInt(year) == calendar.get(Calendar.YEAR)) && (Integer.parseInt(month) == calendar.get(Calendar.MONTH) + 1) && (position + 1 > this_week)) {
                    Common.getInstance().toastShow(context, "현재보다 미래의 일자는 선택할 수 없습니다.");
                    select_weekSN.setSelection(this_week - 1);

                } else {
                    week = (position + 1) + "";
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });

        //라디오버튼 > 일간
        select_type_dayRB.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean checked) {
                if (checked) {
                    select_type_dayRB.setChecked(true);
                    select_type_weekRB.setChecked(false);
                    select_type_monthRB.setChecked(false);
                    select_type_dateRB.setChecked(false);
                    type = "day";

                    Calendar calendar = Calendar.getInstance();
                    SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.KOREA);
                    String today = dataFormat.format(calendar.getTime());
                    report_select_dayTV.setText(today);
                    report_start_timeSN.setSelection(0);
                    report_end_timeSN.setSelection(23);
                    start_time = 0;
                    end_time = 23;

                    report_select_dayLL.setVisibility(View.VISIBLE);
                    select_weekSN.setVisibility(View.GONE);
                    report_select_week_monthLL.setVisibility(View.GONE);
                    report_select_dateLL.setVisibility(View.GONE);

                }
            }
        });

        //일간 >> 일자 선택
        report_select_dayTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                Calendar cal = Calendar.getInstance();
                DatePickerDialog dialog = new DatePickerDialog(getContext(), day_CallbackMethod, cal.get(Calendar.YEAR), cal.get(Calendar.MONTH), cal.get(Calendar.DATE));
                dialog.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                dialog.show();
            }
        });

        day_CallbackMethod = new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {

                int month = monthOfYear + 1;
                String con_month = month + "";
                if (month < 10) {
                    con_month = "0" + con_month;
                }

                String con_day = dayOfMonth + "";
                if (dayOfMonth < 10) {
                    con_day = "0" + con_day;
                }
                report_select_dayTV.setText(year + "." + con_month + "." + con_day);
            }
        };

        //일간 >> 시작시간 선택
        report_start_timeSN.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                if (i > end_time) {
                    Common.getInstance().toastShow(context, "시작시간을 종료시간보다 작게 설정하세요.");
                    report_start_timeSN.setSelection(start_time);
                } else {
                    start_time = i;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });


        //일간 >> 종료시간 선택
        report_end_timeSN.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {

                if (i < start_time) {
                    Common.getInstance().toastShow(context, "종료시간을 시작시간보다 크게 설정하세요.");
                    report_end_timeSN.setSelection(end_time);
                } else {
                    end_time = i;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });

        //라디오버튼 > 주간
        select_type_weekRB.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean checked) {
                if (checked) {
                    select_type_dayRB.setChecked(false);
                    select_type_weekRB.setChecked(true);
                    select_type_monthRB.setChecked(false);
                    select_type_dateRB.setChecked(false);
                    type = "week";
                    week = this_week + "";

                    report_select_dayLL.setVisibility(View.GONE);
                    select_weekSN.setVisibility(View.VISIBLE);
                    report_select_week_monthLL.setVisibility(View.VISIBLE);
                    report_select_dateLL.setVisibility(View.GONE);

                    select_yearSN.setSelection(year_adapter.getCount() - 1);
                    select_monthSN.setSelection(this_month - 1);
                    select_weekSN.setSelection(this_week - 1);
                    init_week = false;
                }
            }
        });

        //라디오버튼 > 월간
        select_type_monthRB.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean checked) {
                if (checked) {
                    select_type_dayRB.setChecked(false);
                    select_type_monthRB.setChecked(true);
                    select_type_weekRB.setChecked(false);
                    select_type_dateRB.setChecked(false);
                    type = "month";
                    week = "0";

                    report_select_dayLL.setVisibility(View.GONE);
                    select_weekSN.setVisibility(View.GONE);
                    report_select_week_monthLL.setVisibility(View.VISIBLE);
                    report_select_dateLL.setVisibility(View.GONE);

                    select_yearSN.setSelection(year_adapter.getCount() - 1);
                    select_monthSN.setSelection(this_month - 1);

                }
            }
        });

        //라디오버튼 > 기간
        select_type_dateRB.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean checked) {
                if (checked) {
                    select_type_dayRB.setChecked(false);
                    select_type_monthRB.setChecked(false);
                    select_type_weekRB.setChecked(false);
                    select_type_dateRB.setChecked(true);
                    type = "date";

                    report_select_dayLL.setVisibility(View.GONE);
                    select_weekSN.setVisibility(View.GONE);
                    report_select_week_monthLL.setVisibility(View.GONE);
                    report_select_dateLL.setVisibility(View.VISIBLE);

                    Calendar calendar = Calendar.getInstance();
                    SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.KOREA);
                    String today = dataFormat.format(calendar.getTime());
                    calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DATE) - 1);
                    String yesterday = dataFormat.format(calendar.getTime());

                    report_start_dateTV.setText(yesterday);
                    report_end_dateTV.setText(today);

                    min_calendar = Calendar.getInstance();
                }
            }
        });

        //단일분석 시작기간 클릭리스너
        report_start_dateTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Calendar cal = Calendar.getInstance();
                DatePickerDialog dialog = new DatePickerDialog(getContext(), report_callbackMethod, cal.get(Calendar.YEAR), cal.get(Calendar.MONTH), cal.get(Calendar.DATE) - 1);
                dialog.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                dialog.setOnDismissListener(new OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialogInterface) {
                        DatePickerDialog dialog = new DatePickerDialog(getContext(), report_endCallbackMethod, min_calendar.get(Calendar.YEAR), min_calendar.get(Calendar.MONTH), min_calendar.get(Calendar.DATE));
                        dialog.getDatePicker().setMinDate(min_calendar.getTimeInMillis());
                        Calendar max = Calendar.getInstance();
                        max.set(min_calendar.get(Calendar.YEAR), min_calendar.get(Calendar.MONTH) + 1, min_calendar.get(Calendar.DATE));
                        dialog.getDatePicker().setMaxDate(max.getTimeInMillis());
                        dialog.show();
                    }
                });
                dialog.show();
            }
        });

        //단일분석 마지막기간 클릭리스너
        report_end_dateTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (min_calendar != null) {
                    DatePickerDialog dialog = new DatePickerDialog(getContext(), report_endCallbackMethod, min_calendar.get(Calendar.YEAR), min_calendar.get(Calendar.MONTH), min_calendar.get(Calendar.DATE));
                    dialog.getDatePicker().setMinDate(min_calendar.getTimeInMillis());
                    Calendar max = Calendar.getInstance();
                    max.set(min_calendar.get(Calendar.YEAR), min_calendar.get(Calendar.MONTH) + 1, min_calendar.get(Calendar.DATE));
                    dialog.getDatePicker().setMaxDate(max.getTimeInMillis());
                    dialog.show();
                } else {
                    Common.getInstance().toastShow(context, "먼저 시작기간을 선택해주세요.");
                }
            }
        });

        report_callbackMethod = new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {

                int month = monthOfYear + 1;
                String con_month = month + "";
                if (month < 10) {
                    con_month = "0" + con_month;
                }

                String con_day = dayOfMonth + "";
                if (dayOfMonth < 10) {
                    con_day = "0" + con_day;
                }
                report_start_dateTV.setText(year + "." + con_month + "." + con_day);
                min_calendar.set(year, monthOfYear, dayOfMonth + 1);
                SimpleDateFormat new_dataFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.KOREA);
                try {
                    report_end_dateTV.setText(new_dataFormat.parse(min_calendar.getTime() + "") + "");
                } catch (ParseException e) {
                    report_end_dateTV.setText(year + "." + con_month + "." + con_day);
                    e.printStackTrace();
                }
            }
        };

        report_endCallbackMethod = new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {

                int month = monthOfYear + 1;
                String con_month = month + "";
                if (month < 10) {
                    con_month = "0" + con_month;
                }

                String con_day = dayOfMonth + "";
                if (dayOfMonth < 10) {
                    con_day = "0" + con_day;
                }
                report_end_dateTV.setText(year + "." + con_month + "." + con_day);
            }
        };


        //단일분석 클릭리스너
        reportTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                reportTV.setTextColor(Color.WHITE);
                reportTV.setBackground(null);

                compareTV.setTextColor(getContext().getResources().getColor(R.color.color_main));
                compareTV.setBackgroundResource(R.drawable.bg_round_white_except_left);

                reportLL.setVisibility(View.VISIBLE);
                compareLL.setVisibility(View.GONE);
                is_report = true;
            }
        });


        //다중비교 클릭리스너
        compareTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                compareTV.setTextColor(Color.WHITE);
                compareTV.setBackground(null);

                reportTV.setTextColor(getContext().getResources().getColor(R.color.color_main));
                reportTV.setBackgroundResource(R.drawable.bg_round_white_except_right);

                reportLL.setVisibility(View.GONE);
                compareLL.setVisibility(View.VISIBLE);
                is_report = false;

                mc_idx_list = new ArrayList<>();
                mc_idx_list.add(ori_machine_data.getMcIdx());

                DlgMonitoringReportCompareAdapter adapter = new DlgMonitoringReportCompareAdapter(context, new DlgMonitoringReportCompareAdapter.checkClickListener() {
                    @Override
                    public void clickBtn(String mac, boolean is_checked) {

                        if (is_checked) {
                            mc_idx_list.add(mac);
                        } else {
                            mc_idx_list.remove(mac);
                        }
                    }
                });
                compare_mac_listRV.setAdapter(adapter);
                if (machineItem.getArrayitem().get(0).getMcIdx() != null)
                    adapter.addItem(machineItem.getArrayitem());
                else Toast.makeText(context, "비교할 기계가 없습니다", Toast.LENGTH_LONG).show();

                Calendar calendar = Calendar.getInstance();
                SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.KOREA);
                String today = dataFormat.format(calendar.getTime());
                calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DATE) - 1);
                String yesterday = dataFormat.format(calendar.getTime());

                compare_start_dateTV.setText(yesterday);
                compare_end_dateTV.setText(today);

                compare_ori_macTV.setText("MAC ( " + ori_machine_data.getMcIotMac() + " )");
                compare_ori_cp_nameTV.setText(cp_name);
                compare_ori_airlineTV.setText("[ " + ori_machine_data.getMcAirline() + " ]");
                compare_ori_pd_nameTV.setText(ori_machine_data.getPdName());

                min_calendar = Calendar.getInstance();

            }
        });

        //다중비교 시작기간 클릭리스너
        compare_start_dateTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Calendar cal = Calendar.getInstance();
                DatePickerDialog dialog = new DatePickerDialog(getContext(), callbackMethod, cal.get(Calendar.YEAR), cal.get(Calendar.MONTH), cal.get(Calendar.DATE) - 1);
                dialog.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                dialog.setOnDismissListener(new OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialogInterface) {
                        DatePickerDialog dialog = new DatePickerDialog(getContext(), endCallbackMethod, min_calendar.get(Calendar.YEAR), min_calendar.get(Calendar.MONTH), min_calendar.get(Calendar.DATE));
                        dialog.getDatePicker().setMinDate(min_calendar.getTimeInMillis());
                        Calendar max = Calendar.getInstance();
                        max.set(min_calendar.get(Calendar.YEAR), min_calendar.get(Calendar.MONTH) + 1, min_calendar.get(Calendar.DATE));
                        dialog.getDatePicker().setMaxDate(max.getTimeInMillis());
                        dialog.show();
                    }
                });
                dialog.show();
            }
        });

        //다중비교 마지막기간 클릭리스너
        compare_end_dateTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (min_calendar != null) {
                    DatePickerDialog dialog = new DatePickerDialog(getContext(), endCallbackMethod, min_calendar.get(Calendar.YEAR), min_calendar.get(Calendar.MONTH), min_calendar.get(Calendar.DATE));
                    dialog.getDatePicker().setMinDate(min_calendar.getTimeInMillis());
                    Calendar max = Calendar.getInstance();
                    max.set(min_calendar.get(Calendar.YEAR), min_calendar.get(Calendar.MONTH) + 1, min_calendar.get(Calendar.DATE));
                    dialog.getDatePicker().setMaxDate(max.getTimeInMillis());
                    dialog.show();
                } else {
                    Common.getInstance().toastShow(context, "먼저 시작기간을 선택해주세요.");
                }
            }
        });

        callbackMethod = new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {

                int month = monthOfYear + 1;
                String con_month = month + "";
                if (month < 10) {
                    con_month = "0" + con_month;
                }

                String con_day = dayOfMonth + "";
                if (dayOfMonth < 10) {
                    con_day = "0" + con_day;
                }
                compare_start_dateTV.setText(year + "." + con_month + "." + con_day);
                min_calendar = Calendar.getInstance();
                min_calendar.set(year, monthOfYear, dayOfMonth + 1);
                SimpleDateFormat new_dataFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.KOREA);
                try {
                    compare_end_dateTV.setText(new_dataFormat.parse(min_calendar.getTime() + "") + "");
                } catch (ParseException e) {
                    compare_end_dateTV.setText(year + "." + con_month + "." + con_day);
                    e.printStackTrace();
                }
            }
        };

        endCallbackMethod = new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {

                int month = monthOfYear + 1;
                String con_month = month + "";
                if (month < 10) {
                    con_month = "0" + con_month;
                }

                String con_day = dayOfMonth + "";
                if (dayOfMonth < 10) {
                    con_day = "0" + con_day;
                }
                compare_end_dateTV.setText(year + "." + con_month + "." + con_day);
            }
        };

        //정기발행 설정 클릭리스너
        report_regular_publishTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent = new Intent(context, FragmentActivity.class);
                intent.putExtra("title", "소비전력 레포트 발행설정");
                intent.putExtra("type", "report_publish_setting");
                intent.putExtra("value1", ori_machine_data.getAgIdx());
                intent.putExtra("value2", ori_machine_data.getPtIdx());

                context.startActivity(intent);
            }
        });


        //취소버튼 클릭리스너
        select_cancelTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
            }
        });

        //확인버튼 클릭리스너
        select_confirmTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (is_report) {

                    if (type.equals("date")) {

                        if (report_start_dateTV.getText().equals(report_end_dateTV.getText())) {
                            Common.getInstance().toastShow(context, "분석 할 기간을 선택해주세요.");
                            return;
                        }

                        Intent intent = new Intent(context, FragmentActivity.class);
                        intent.putExtra("title", "모니터링 레포트");
                        intent.putExtra("type", "monitoring_report2");
                        intent.putExtra("value1", ori_machine_data.getMcIdx());
                        intent.putExtra("select_type", type);
                        intent.putExtra("start_date", report_start_dateTV.getText().toString());
                        intent.putExtra("end_date", report_end_dateTV.getText().toString());
                        intent.putExtra("cp_name", cp_name);
                        intent.putExtra("pt_name", ori_machine_data.getPtName());
                        context.startActivity(intent);

                    } else {

                        if (type.equals("day")) {

                            String date = report_select_dayTV.getText().toString();
                            String start = start_time + "";
                            String end = end_time + "";

                            if (start_time < 10) start = "0" + start;
                            if (end_time < 10) end = "0" + end;

                            Intent intent = new Intent(context, FragmentActivity.class);
                            intent.putExtra("title", "모니터링 레포트");
                            intent.putExtra("type", "monitoring_report2");
                            intent.putExtra("value1", ori_machine_data.getMcIdx());
                            intent.putExtra("select_type", type);
                            intent.putExtra("start_date", date + "." + start);
                            intent.putExtra("end_date", date + "." + end);
                            intent.putExtra("cp_name", cp_name);
                            intent.putExtra("pt_name", ori_machine_data.getPtName());
                            context.startActivity(intent);

                        } else {

                            Intent intent = new Intent(context, FragmentActivity.class);
                            intent.putExtra("title", "모니터링 레포트");
                            intent.putExtra("type", "monitoring_report");
                            intent.putExtra("value1", ori_machine_data.getMcIdx());
                            intent.putExtra("select_type", type);
                            intent.putExtra("year", year);
                            intent.putExtra("month", month);
                            intent.putExtra("week", week);
                            intent.putExtra("cp_name", cp_name);
                            intent.putExtra("pt_name", ori_machine_data.getPtName());

                            context.startActivity(intent);
                        }
                    }

                } else {

                    if (mc_idx_list.size() < 2) {
                        Common.getInstance().toastShow(context, "비교 할 기계를 한 대 이상 선택해주세요.");
                        return;
                    }

                    if (compare_start_dateTV.getText().equals(compare_end_dateTV.getText())) {
                        Common.getInstance().toastShow(context, "비교 할 기간을 선택해주세요.");
                        return;
                    }

                    Intent intent = new Intent(context, FragmentActivity.class);
                    intent.putExtra("title", "모니터링 레포트");
                    intent.putExtra("type", "monitoring_compare");
                    intent.putExtra("value1", mc_idx_list);
                    intent.putExtra("value2", compare_start_dateTV.getText());
                    intent.putExtra("value3", compare_end_dateTV.getText());
                    context.startActivity(intent);
                }

                dismiss();
            }
        });
    }
}


