package kr.co.compcareworker.Util.CustomView;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.Toast;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.HashMap;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.ArrayItem;
import kr.co.compcareworker.Data.EstimateList.QuicksetData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Adapter.QuickSetRecyclerAdapter;
import kr.co.compcareworker.Util.Api.ApiClient;
import kr.co.compcareworker.Util.MyOnItemClick;

public class QuickSetDialog extends Dialog implements MyOnItemClick {

    Context context;
    QuickSetRecyclerAdapter adapter;
    RecyclerView.LayoutManager layoutManager;
    ArrayItem<QuicksetData> quickSet_array;
    QuicksetData quickSet_data;
    Handler hdr;

    ProgressBar quick_progress;
    EditText quick_search_nameET;
    Button quick_searchBtn;
    RecyclerView quickRV;

    FragmentActivity fa;

    private QuicksetDialogListener quicksetDialogListener;

    public interface QuicksetDialogListener {
        void clickBtn(HashMap<String, String> data);
    }

    public QuickSetDialog(Context context, QuicksetDialogListener quicksetDialogListener) {
        super(context);
        this.context = context;
        this.quicksetDialogListener = quicksetDialogListener;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.dlg_quick_set);

        quick_progress = findViewById(R.id.quick_progress);
        quick_search_nameET = findViewById(R.id.quick_search_nameET);
        quick_searchBtn = findViewById(R.id.quick_searchBtn);
        quickRV = findViewById(R.id.quickRV);

        quick_searchBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                quick_progress.setVisibility(View.VISIBLE);

                HashMap<String, String> data = new HashMap();
                data.put("ag_idx", fa.userItem.getArrayitem().getAgIdx());
                data.put("qs_title", quick_search_nameET.getText().toString());
                new ApiClient(data, "proc_quickset_view", hdr);

                quick_search_nameET.getText().clear();
            }
        });

        init_Handler();
        Get_Product();
    }

    void Get_Product() {

        quick_progress.setVisibility(View.VISIBLE);
        HashMap<String, String> data = new HashMap<>();
        data.put("ag_idx", fa.userItem.getArrayitem().getAgIdx());
        new ApiClient(data, "proc_quickset_view", hdr);
    }

    void Set_Content() {

        adapter = new QuickSetRecyclerAdapter(context, hdr, this::onClick);
        layoutManager = new LinearLayoutManager(getContext());
        quickRV.setLayoutManager(layoutManager);
        adapter.addItem(quickSet_array.getArrayitem());
        quickRV.setAdapter(adapter);

        quick_progress.setVisibility(View.GONE);

    }

    //리스트 클릭 시
    @Override
    public void onClick(Bundle value) {

        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(getContext());
        dialogBuilder.setTitle("품목 추가");
        dialogBuilder.setMessage("선택한 Quick 세트를 추가하시겠습니까?");
        dialogBuilder.setPositiveButton("확인", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int i) {

                quick_progress.setVisibility(View.VISIBLE);
                quick_progress.bringToFront();

                HashMap<String, String> data = new HashMap();
                data.put("qs_idx", value.getString("qs_idx"));

                quicksetDialogListener.clickBtn(data);

                hdr.postDelayed(new Runnable() {
                    public void run() {
                        quick_progress.setVisibility(View.GONE);
                    }
                }, 500);
                dialog.dismiss();
            }
        });
        dialogBuilder.setNegativeButton("취소", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });

        dialogBuilder.show();
    }

    void init_Handler() {
        hdr = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);

                if (msg.what == -1) {
                    Toast.makeText(getContext(), msg.obj.toString().replace("\"", ""), Toast.LENGTH_SHORT).show();

                } else if (msg.what == 1) {
                    String url = msg.getData().getString("url");
                    if (url.equals("proc_quickset_view")) {

                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        quickSet_array = new Gson().fromJson(result_item, new TypeToken<ArrayItem<QuicksetData>>() {
                        }.getType());

                        if (quickSet_array.isSuccess()) {
                            if (quickSet_array.size() > 0) {

                                for (int i = 0; i < quickSet_array.size(); i++) {
                                    quickSet_data = quickSet_array.getArrayitem().get(i);
                                }
                            }
                            Set_Content();

                        } else {
                            Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                            dismiss();
                        }
                    }
                }
            }
        };
    }
}
