package kr.co.compcareworker.Util;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;

public class ServiceThread extends Thread {
    private Handler handler;
    private boolean isRun = true;
    private String type, mac, air_line, k, i;
    private static int SLEEP = 1000;

    public ServiceThread(Handler handler, String type, String mac) {
        this.handler = handler;
        this.type = type;
        this.mac = mac;
    }

    public ServiceThread(Handler handler, String type, String mac, String i) {
        this.handler = handler;
        this.type = type;
        this.mac = mac;
        this.i = i;
    }

    public ServiceThread(Handler handler, String type, String mac, String i, String k , String extra) {
        this.handler = handler;
        this.type = type;
        this.mac = mac;
        this.i = i;
        this.k = k;
    }

    public ServiceThread(Handler handler, String type, String mac, String k, String air_line) {
        this.handler = handler;
        this.type = type;
        this.mac = mac;
        this.k = k;
        this.air_line = air_line;
    }

    public void stopForever() {
        synchronized (this) {
            this.isRun = false;
//            interrupt();
        }
    }

    public String getMac(){
        return mac;
    }

    public void run() {
        //반복적으로 수행할 작업을 한다.
        while (isRun) {

            if(Thread.interrupted()) {break;}

            //쓰레드에 있는 핸들러에게 메세지를 보냄
            Message message = new Message();
            if(TextUtils.isEmpty(i)){
                message.obj = mac;
            } else {
                if(TextUtils.isEmpty(k)){
                    message.obj = mac+"i"+i;
                } else {
                    message.obj = mac+"i"+i+"k"+k;
                }
            }

            handler.sendMessage(message);

            if (type.equals("monitoring")) {

                try {
                    Thread.sleep(SLEEP);
                } catch (Exception e) {
                    e.printStackTrace();
                    break;
                }

            } else {
                stopForever();
            }
        }
        interrupt();
    }
}
