package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.Data.Product.MonitoringData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;
import kr.co.compcarecompany.Util.ConvertTimeZone;

public class AirLeakAdapter extends RecyclerView.Adapter<AirLeakAdapter.ItemViewHolder> {

    Context context;
    String date_type;

    private ArrayList<MachineItem> items = new ArrayList<>();

    public AirLeakAdapter(Context context, String date_type) {
        this.context = context;
        this.date_type = date_type;
    }

    @NonNull
    @Override
    public AirLeakAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_monitoring, viewGroup, false);
        return new AirLeakAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull AirLeakAdapter.ItemViewHolder itemViewHolder, int position) {
        try {
            itemViewHolder.onBind(items.get(position));
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItems(ArrayList<MachineItem> data) {
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItems() {
        items.clear();
        notifyDataSetChanged();
    }

    class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView monitor_dateTV, monitor_valueTV;
        ImageView monitor_conditionIV;
        LinearLayout monitorLL;

        ItemViewHolder(View itemView) {
            super(itemView);

            monitor_dateTV = itemView.findViewById(R.id.monitor_dateTV);
            monitor_valueTV = itemView.findViewById(R.id.monitor_valueTV);
            monitor_conditionIV = itemView.findViewById(R.id.monitor_conditionIV);
            monitorLL = itemView.findViewById(R.id.monitorLL);
        }

        void onBind(MachineItem data) throws ParseException {

            ConvertTimeZone timeZone = new ConvertTimeZone();
            String time = "";

            if (data.getTime() != null) {
                if (TextUtils.isEmpty(date_type) || (date_type.equals("day"))) {
                    time = timeZone.convertKoreaTimeS(data.getTime());

                } else if (date_type.equals("week") || date_type.equals("month")) {
                    time = timeZone.convertKoreaTimeD(data.getTime());
                }
            }

            float value = Float.parseFloat(Common.getInstance().valueConvert1(data.getMcAirLeakValue()));
            float std_value = Float.parseFloat(data.getMcAirLeakStd());
            float range = Float.parseFloat(data.getMcAirLeakRange());
            float min_value = std_value - range;

            if (value < min_value) monitor_conditionIV.setImageResource(R.drawable.icon_red_square);
            else monitor_conditionIV.setImageResource(R.drawable.icon_green_square);
            monitor_dateTV.setText(time);
            monitor_valueTV.setText("[ " + value + " Bar ]");
        }
    }
}
