package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class ElectricChargeCalculatorAdapter extends RecyclerView.Adapter<ElectricChargeCalculatorAdapter.ItemViewHolder> {

    Context context;

    private ArrayList<MachineItem> items = new ArrayList<>();

    public ElectricChargeCalculatorAdapter(@NonNull Context context) {
        this.context = context;
    }

    @NonNull
    @Override
    public ElectricChargeCalculatorAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_electric_charge_calculator, viewGroup, false);

        return new ElectricChargeCalculatorAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ElectricChargeCalculatorAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));
        itemViewHolder.cal_numTV.setText((position +1) + " 번");

        long sum = 0;
        int consumption = 0;

        if (items.get(position).getPowerConsumptionData()!=null) {

            for (int i = 0; i < items.get(position).getPowerConsumptionData().size(); i++) {
                String consumption_sum = Common.getInstance().isNullToZero(items.get(position).getPowerConsumptionData().get(i).getPowerConsumptionSum());
                sum = sum + Integer.parseInt(Common.getInstance().valueConvert(consumption_sum));
            }

            if (sum > 0) {
                consumption = (int) sum / 720;
                itemViewHolder.cal_consumption_sumTV.setText(Common.getInstance().moneyFormatToWon(consumption));
                itemViewHolder.cal_chargeTV.setText(Common.getInstance().moneyFormatToWon(consumption*120));
            } else {
                itemViewHolder.cal_consumption_sumTV.setText("0");
                itemViewHolder.cal_chargeTV.setText("0");
            }
        } else {
            itemViewHolder.cal_consumption_sumTV.setText("0");
            itemViewHolder.cal_chargeTV.setText("0");
        }

        int finalConsumption = consumption;
        itemViewHolder.cal_base_chargeET.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if (charSequence.length() > 2) {
                    int base = Integer.parseInt(itemViewHolder.cal_base_chargeET.getText().toString());
                    itemViewHolder.cal_chargeTV.setText(Common.getInstance().moneyFormatToWon(base * finalConsumption));
                }
            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<MachineItem> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView cal_numTV, cal_consumption_sumTV, cal_chargeTV;
        EditText cal_base_chargeET;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            cal_numTV = itemView.findViewById(R.id.cal_numTV);
            cal_consumption_sumTV = itemView.findViewById(R.id.cal_consumption_sumTV);
            cal_base_chargeET = itemView.findViewById(R.id.cal_base_chargeET);
            cal_chargeTV = itemView.findViewById(R.id.cal_chargeTV);
        }

        void onBind(MachineItem data) {

            cal_base_chargeET.setText("120");

        }
    }
}



