package kr.co.compcarecompany.Util.Adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.ExchangeData;
import kr.co.compcarecompany.R;

public class ExchangeLogAdapter extends RecyclerView.Adapter<ExchangeLogAdapter.ItemViewHolder> {

    private ArrayList<ExchangeData> items = new ArrayList<>();

    @NonNull
    @Override
    public ExchangeLogAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_exchange_log, viewGroup, false);
        return new ExchangeLogAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ExchangeLogAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<ExchangeData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView exchange_dateTV, running_timeTV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            running_timeTV = itemView.findViewById(R.id.running_timeTV);
            exchange_dateTV = itemView.findViewById(R.id.exchange_dateTV);
        }

        void onBind(ExchangeData data) {
            exchange_dateTV.setText(data.getMcExchangedt());
            running_timeTV.setText(data.getMcRunningtime() + " / " + data.getMcCycle() + " (hr)");
        }
    }
}
