package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;
import java.util.List;

import kr.co.compcarecompany.Activity.FragmentActivity;
import kr.co.compcarecompany.Data.Product.ReportData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.CustomView.ReportDialog;
import kr.co.compcarecompany.Util.CustomView.ReportModifyDialog;
import kr.co.compcarecompany.Util.CustomView.ServiceDetailDialog;

public class MachineManagementReportAdapter extends RecyclerView.Adapter<MachineManagementReportAdapter.ItemViewHolder> {

    private ArrayList<ReportData> items = new ArrayList<>();
    private Context context;
    private Handler handler;
    private String ag_idx, pt_idx, mem_id;
    private FragmentActivity frag;

    MachineManagementReportAdapter(Context context, Handler handler, String ag_idx, String pt_idx, String mem_id, FragmentActivity frag) {
        this.context = context;
        this.handler = handler;
        this.ag_idx = ag_idx;
        this.pt_idx = pt_idx;
        this.mem_id = mem_id;
        this.frag = frag;
    }

    @NonNull
    @Override
    public MachineManagementReportAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_management_report, viewGroup, false);
        return new MachineManagementReportAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MachineManagementReportAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        itemViewHolder.reportTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (items.get(position).getArIdx() != null) {
                    //작업일지 가져오기
                    ReportModifyDialog dialog = new ReportModifyDialog(context, handler, items.get(position).getArIdx(), pt_idx, ag_idx, mem_id, frag);
                    dialog.show();

                } else {
                    //서비스 레포트 가져오기
                    ServiceDetailDialog dialog = new ServiceDetailDialog(context, handler, items.get(position).getWo_idx());
                    dialog.show();
                }
            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<ReportData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView reportTV;
        RecyclerView report_alarmRV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            reportTV = itemView.findViewById(R.id.reportTV);
            report_alarmRV = itemView.findViewById(R.id.report_alarmRV);

        }

        void onBind(ReportData data) {

            if (data.getArIdx() != null) {
                reportTV.setText("점검 일지");
            } else {
                reportTV.setText("서비스 레포트");
            }

//            MachineManagementDetailAdapter detailAdapter = new MachineManagementDetailAdapter("report");
//            report_alarmRV.setAdapter(detailAdapter);
//            detailAdapter.addItem(data.getReports());
        }
    }
}

