package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Activity.FragmentActivity;
import kr.co.compcarecompany.Data.Company.CompanyData;
import kr.co.compcarecompany.R;

public class MachineManagementReportTitleAdapter extends RecyclerView.Adapter<MachineManagementReportTitleAdapter.ItemViewHolder> {

    private ArrayList<CompanyData> items = new ArrayList<>();
    private Context context;
    private Handler handler;
    private FragmentActivity fa;

    private MachineManagementReportTitleAdapter.OnLoadMoreListener OnLoadMoreListener;

    public interface OnLoadMoreListener {
        void onLoadMore(int position);
    }

    public MachineManagementReportTitleAdapter(Context context, Handler handler, MachineManagementReportTitleAdapter.OnLoadMoreListener OnLoadMoreListener, FragmentActivity fa) {
        this.context = context;
        this.handler = handler;
        this.OnLoadMoreListener = OnLoadMoreListener;
        this.fa = fa;
    }

    @NonNull
    @Override
    public MachineManagementReportTitleAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_alarm_report_title, viewGroup, false);
        return new MachineManagementReportTitleAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MachineManagementReportTitleAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        if (position == getItemCount() - 1) {
            if (OnLoadMoreListener != null) {
                OnLoadMoreListener.onLoadMore(position);
            }
        }

        MachineManagementReportContentAdapter adapter = new MachineManagementReportContentAdapter(context, handler, new MachineManagementReportContentAdapter.OnLoadMoreListener() {
            @Override
            public void onLoadMore(int position) {

            }
        }, new MachineManagementReportContentAdapter.OnReportListener() {
            @Override
            public void onClick(int position) {

            }
        }, new MachineManagementReportContentAdapter.OnAlarmListener() {
            @Override
            public void onClick(int position) {

            }
        }, fa);

        itemViewHolder.report_contentRV.setAdapter(adapter);
        if (items.get(position).getReportList() != null) adapter.addItem(items.get(position).getReportList());

    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<CompanyData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void addItemMore(ArrayList<CompanyData> lst) {
        items.addAll(lst);
        notifyItemRangeChanged(0, items.size());
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        //작업일지
        TextView cp_nameTV, cp_airlineTV;
        RecyclerView report_contentRV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            cp_nameTV = itemView.findViewById(R.id.cp_nameTV);
            cp_airlineTV = itemView.findViewById(R.id.cp_airlineTV);
            report_contentRV = itemView.findViewById(R.id.report_contentRV);
        }

        void onBind(CompanyData data) {
            cp_nameTV.setText(data.getCpName());
            cp_airlineTV.setText("[ " + data.getCpAirlineStr() + " ]");

        }
    }
}
