package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class MonitoringCompareReportAdapter extends RecyclerView.Adapter<MonitoringCompareReportAdapter.ItemViewHolder> {

    Context context;

    private ArrayList<MachineItem> items = new ArrayList<>();

    public MonitoringCompareReportAdapter(@NonNull Context context) {
        this.context = context;
    }

    @NonNull
    @Override
    public MonitoringCompareReportAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_compare_report, viewGroup, false);

        return new MonitoringCompareReportAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MonitoringCompareReportAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));
        itemViewHolder.charge_numTV.setText((position + 1) + " 번");
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<MachineItem> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView charge_numTV, charge_consumption_sumTV, charge_consumption_averageTV, charge_operating_timeTV, chargeTV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            charge_numTV = itemView.findViewById(R.id.charge_numTV);
            charge_consumption_sumTV = itemView.findViewById(R.id.charge_consumption_sumTV);
            charge_consumption_averageTV = itemView.findViewById(R.id.charge_consumption_averageTV);
            charge_operating_timeTV = itemView.findViewById(R.id.charge_operating_timeTV);
            chargeTV = itemView.findViewById(R.id.chargeTV);

        }

        void onBind(MachineItem data) {

            long sum = 0;
            int count = 0;

            if (data.getPowerConsumptionData() !=null) {

                for (int i = 0; i < data.getPowerConsumptionData().size(); i++) {
                    String consumption_sum = Common.getInstance().isNullToZero(data.getPowerConsumptionData().get(i).getPowerConsumptionSum());
                    String consumption_count = Common.getInstance().isNullToZero(data.getPowerConsumptionData().get(i).getPowerCount());

                    sum = sum + Integer.parseInt(Common.getInstance().valueConvert(consumption_sum));
                    count = count + Integer.parseInt(Common.getInstance().valueConvert(consumption_count));
                }
            }

            charge_consumption_averageTV.setText("0");

            if (data.getPowerConsumptionData() != null) {
                int total = (int) sum / 720;
                int total_count = count / 720;
                int avg_power = 0;
                if (total_count > 0) avg_power = total / total_count;

                charge_consumption_sumTV.setText(Common.getInstance().moneyFormatToWon(total));
                charge_consumption_averageTV.setText(Common.getInstance().valueConvert(avg_power+""));
                charge_operating_timeTV.setText(Common.getInstance().valueConvert(total_count + ""));
                chargeTV.setText(Common.getInstance().moneyFormatToWon(total * 120) + "");

            } else {
                charge_consumption_sumTV.setText("0");
                charge_operating_timeTV.setText("0");
                chargeTV.setText("0");
            }
        }
    }
}
