package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

import kr.co.compcarecompany.Data.Product.RelayData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class RelayScheduleAdapter extends RecyclerView.Adapter<RelayScheduleAdapter.ItemViewHolder> {

    Context context;
    private ArrayList<RelayData> items = new ArrayList<>();
    private boolean edit_mode;
    private boolean schedule_active;

    public interface OnItemClickListener {
        void onItemClick(HashMap<String, String> data);
    }

    private RelayScheduleAdapter.OnItemClickListener mListener = null;

    public RelayScheduleAdapter(@NonNull Context context, Boolean edit_mode) {
        this.context = context;
        this.edit_mode = edit_mode;
    }

    public RelayScheduleAdapter(@NonNull Context context, Boolean edit_mode, Boolean schedule_active) {
        this.context = context;
        this.edit_mode = edit_mode;
        this.schedule_active = schedule_active;
    }

    public RelayScheduleAdapter(@NonNull Context context, Boolean edit_mode, Boolean schedule_active, RelayScheduleAdapter.OnItemClickListener mListener) {
        this.context = context;
        this.edit_mode = edit_mode;
        this.mListener = mListener;
        this.schedule_active = schedule_active;
    }

    @NonNull
    @Override
    public RelayScheduleAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_relay_schedule, viewGroup, false);
        return new RelayScheduleAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull RelayScheduleAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));
        if (edit_mode) {
            itemViewHolder.closeIV.setVisibility(View.VISIBLE);
            itemViewHolder.time_periodTV.setVisibility(View.GONE);
        }
//
//        if(!schedule_active){
//            itemViewHolder.relay_stateIV.setImageResource(R.drawable.icon_power_gray);
//            itemViewHolder.relay_stateIV.clearAnimation();
//        }
//
        final Animation animation = new AlphaAnimation(1, 0);
        animation.setDuration(1500);
        animation.setInterpolator(new LinearInterpolator());
        animation.setRepeatCount(Animation.INFINITE);
        animation.setRepeatMode(Animation.RESTART);

        if(edit_mode){
            itemViewHolder.relay_stateIV.setVisibility(View.GONE);
        }

        if (schedule_active) {
            itemViewHolder.relay_stateIV.setImageResource(R.drawable.icon_power_green);
            itemViewHolder.relay_stateIV.startAnimation(animation);

        } else {
            itemViewHolder.relay_stateIV.setImageResource(R.drawable.icon_power_red);
            itemViewHolder.relay_stateIV.clearAnimation();
        }

        itemViewHolder.closeIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //rs_idx 전달 >> db에서 삭제하기
                HashMap<String, String> data = new HashMap<>();

                if (items.get(position).getRsIdx() != null) {
                    data.put("rs_idx", items.get(position).getRsIdx());
                }
                data.put("position", position + "");
                mListener.onItemClick(data);
            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItems(ArrayList<RelayData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void addItem(RelayData data) {

        items.add(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    public void removeItem(int position) {
        items.remove(position);
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView start_dayTV, start_timeTV, end_dayTV, end_timeTV, schedule_memoTV, time_periodTV;
        ImageView closeIV, relay_stateIV;
        LinearLayout item_scheduleLL;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            item_scheduleLL = itemView.findViewById(R.id.item_scheduleLL);
            start_dayTV = itemView.findViewById(R.id.start_dayTV);
            start_timeTV = itemView.findViewById(R.id.start_timeTV);
            end_dayTV = itemView.findViewById(R.id.end_dayTV);
            end_timeTV = itemView.findViewById(R.id.end_timeTV);
            schedule_memoTV = itemView.findViewById(R.id.schedule_memoTV);
            closeIV = itemView.findViewById(R.id.closeIV);
            time_periodTV = itemView.findViewById(R.id.time_periodTV);
            relay_stateIV = itemView.findViewById(R.id.relay_stateIV);
        }

        void onBind(RelayData data) {
            int s_day = Integer.parseInt(data.getRsStartDay());
            int e_day = Integer.parseInt(data.getRsEndDay());

            int s_hour = Integer.parseInt(data.getRsStartTime().substring(0, 2));
            int s_min = Integer.parseInt(data.getRsStartTime().substring(3, 5));
            int e_hour = Integer.parseInt(data.getRsEndTime().substring(0, 2));
            int e_min = Integer.parseInt(data.getRsEndTime().substring(3, 5));

            set_day(data.getRsStartDay(), start_dayTV);
            set_day(data.getRsEndDay(), end_dayTV);
            start_timeTV.setText(data.getRsStartTime());
            end_timeTV.setText(data.getRsEndTime());

            if (data.getRsMemo() != null && !data.getRsMemo().isEmpty() && !data.getRsMemo().equals("")) {
                schedule_memoTV.setVisibility(View.VISIBLE);
                schedule_memoTV.setText(data.getRsMemo());
            }

            set_time_period(s_day, e_day, s_hour, s_min, e_hour, e_min, time_periodTV);
//            set_schedule_state(s_day, e_day, s_hour, s_min, e_hour, e_min, relay_stateIV);
        }

        void set_schedule_state(int s_day, int e_day, int s_hour, int s_min, int e_hour, int e_min, ImageView imageView) {

            String today = get_today();
            String now_time = today.substring(1, 3);
            String now_min = today.substring(3, 5);
            today = today.substring(0, 1);

            int time = (Integer.parseInt(now_time) * 60 + Integer.parseInt(now_min));

            final Animation animation = new AlphaAnimation(1, 0);
            animation.setDuration(1500);
            animation.setInterpolator(new LinearInterpolator());
            animation.setRepeatCount(Animation.INFINITE);
            animation.setRepeatMode(Animation.RESTART);

            if (Integer.parseInt(today) >= s_day && Integer.parseInt(today) <= e_day) {
                if (time >= (s_hour * 60 + s_min) && time < (e_hour * 60 + e_min)) {
                    imageView.setImageResource(R.drawable.icon_power_green);
                    imageView.startAnimation(animation);

                } else {
                    imageView.setImageResource(R.drawable.icon_power_gray);
                }
            } else {
                imageView.setImageResource(R.drawable.icon_power_gray);
            }
        }

        private String get_today() {

            Calendar calendar = Calendar.getInstance();
            int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
            int hour = calendar.get(Calendar.HOUR_OF_DAY);
            int min = calendar.get(Calendar.MINUTE);

            String con_hour = hour + "";
            String con_min = min + "";

            if (hour < 10) {
                con_hour = "0" + con_hour;
            }

            if (min < 10) {
                con_min = "0" + con_min;
            }

            return (dayOfWeek - 1) + con_hour + con_min;
        }

        void set_time_period(int s_day, int e_day, int s_hour, int s_min, int e_hour, int e_min, TextView textView) {
            int time_period;
            int time;
            int min;

            if (s_day < e_day) {
                time_period = (60 * ((e_day - s_day) * 24 + e_hour) + e_min) - (60 * s_hour + s_min);

            } else if (s_day == e_day) {
                time_period = (60 * e_hour + e_min) - (60 * s_hour + s_min);

            } else {
                time_period = (60 * ((7 - (s_day - e_day)) * 24 + e_hour) + e_min) - (60 * s_hour + s_min);
            }

            time = time_period / 60;
            min = time_period % 60;

            if (time == 0 && min > 0) {
                textView.setText(min + "분 가동");

            } else if (min == 0 && time > 0) {
                textView.setText(time + "시간 가동");

            } else {
                textView.setText(time + "시간 " + min + "분\n가동");
            }
        }

        void set_day(String day, TextView textView) {
            switch (day) {
                case "0":
                    textView.setText("일");
                    break;
                case "1":
                    textView.setText("월");
                    break;
                case "2":
                    textView.setText("화");
                    break;
                case "3":
                    textView.setText("수");
                    break;
                case "4":
                    textView.setText("목");
                    break;
                case "5":
                    textView.setText("금");
                    break;
                case "6":
                    textView.setText("토");
                    break;
            }
        }
    }
}
