package kr.co.compcarecompany.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.HashMap;

import kr.co.compcarecompany.Data.ArrayItem;
import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Adapter.DlgAlarmListDetailAdapter;
import kr.co.compcarecompany.Util.Api.ApiClient;

public class AlarmListDialog extends Dialog {

    private Context context;
    private TextView dlg_closeTV, cp_nameTV, mc_airlineTV, dlg_pd_nameTV;
    private ArrayItem<AlarmData> alarmItems;
    private DlgAlarmListDetailAdapter adapter;
    private String ar_idx, cp_idx, type, time, mc_iot_mac, list_type, wo_idx;
    private Handler handler;
    private LinearLayout report_tapLL;
    private LinearLayout work_tapLL;
    private TextView ct1TV, ct2TV, ct3TV, pt1TV, pt2TV, pt3TV, temp1TV, temp2TV, temp3TV;

    public AlarmListDialog(@NonNull Context context, Handler handler, String ar_idx, String wo_idx, String cp_idx, String mc_iot_mac, String type) {
        super(context);
        this.context = context;
        this.handler = handler;
        this.ar_idx = ar_idx;
        this.wo_idx = wo_idx;
        this.cp_idx = cp_idx;
        this.mc_iot_mac = mc_iot_mac;
        this.list_type = type;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_alarm_list);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        RecyclerView dlg_alarm_listRV = findViewById(R.id.dlg_alarm_listRV);
        dlg_closeTV = findViewById(R.id.dlg_closeTV);
        mc_airlineTV = findViewById(R.id.mc_airlineTV);
        cp_nameTV = findViewById(R.id.cp_nameTV);
        dlg_pd_nameTV = findViewById(R.id.dlg_pd_nameTV);

        LinearLayout wo_chart_btnLL = findViewById(R.id.wo_chart_btnLL);
        ct1TV = findViewById(R.id.ct1TV);
        ct2TV = findViewById(R.id.ct2TV);
        ct3TV = findViewById(R.id.ct3TV);
        pt1TV = findViewById(R.id.pt1TV);
        pt2TV = findViewById(R.id.pt2TV);
        pt3TV = findViewById(R.id.pt3TV);
        temp1TV = findViewById(R.id.temp1TV);
        temp2TV = findViewById(R.id.temp2TV);
        temp3TV = findViewById(R.id.temp3TV);

        report_tapLL = findViewById(R.id.report_tapLL);
        work_tapLL = findViewById(R.id.work_tapLL);

        adapter = new DlgAlarmListDetailAdapter(context, list_type, new DlgAlarmListDetailAdapter.detailClickListener() {
            @Override
            public void clickBtn(Bundle bundle) {
                type = bundle.getString("type");
                time = bundle.getString("time");

                HashMap<String, String> data = new HashMap<>();
                data.put("mc_iot_mac", bundle.getString("mc_iot_mac"));
                new ApiClient(data, "proc_admin_get_machine_with_mac", handler);
            }
        });
        dlg_alarm_listRV.setAdapter(adapter);

        ct1TV.setOnClickListener(clickListener);
        ct2TV.setOnClickListener(clickListener);
        ct3TV.setOnClickListener(clickListener);
        pt1TV.setOnClickListener(clickListener);
        pt2TV.setOnClickListener(clickListener);
        pt3TV.setOnClickListener(clickListener);
        temp1TV.setOnClickListener(clickListener);
        temp2TV.setOnClickListener(clickListener);
        temp3TV.setOnClickListener(clickListener);

        if (list_type.equals("work")) {
            wo_chart_btnLL.setVisibility(View.VISIBLE);
            work_tapLL.setVisibility(View.VISIBLE);
            report_tapLL.setVisibility(View.GONE);
        }

        init_Handler();
        init_Listener();
        Get_Alarms();
    }

    private View.OnClickListener clickListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {

            if (v == ct1TV) {
                type = "current1";
            } else if (v == ct2TV) {
                type = "current2";
            } else if (v == ct3TV) {
                type = "current3";
            } else if (v == pt1TV) {
                type = "pressure1";
            } else if (v == pt2TV) {
                type = "pressure2";
            } else if (v == pt3TV) {
                type = "pressure3";
            } else if (v == temp1TV) {
                type = "temperatureNtc";
            } else if (v == temp2TV) {
                type = "temperaturePt";
            } else if (v == temp3TV) {
                type = "temperatureNtc2";
            }

            time = alarmItems.getArrayitem().get(0).getPushDt();

            HashMap<String, String> data = new HashMap<>();
            data.put("mc_iot_mac", alarmItems.getArrayitem().get(0).getMcIotMac());
            new ApiClient(data, "proc_admin_get_machine_with_mac", handler);

        }
    };

    void init_Listener() {

        dlg_closeTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

    }

    void Get_Alarms() {
        HashMap<String, String> data = new HashMap<>();
        if (ar_idx != null && !TextUtils.isEmpty(ar_idx))
            data.put("ar_idx", ar_idx);
        if (wo_idx != null && !TextUtils.isEmpty(wo_idx))
            data.put("wo_idx", wo_idx);
        data.put("cp_idx", cp_idx);
        data.put("mc_iot_mac", mc_iot_mac);
        new ApiClient(data, "proc_get_dlg_alarm_list2", handler);
    }

    void init_Handler() {

        handler = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                String url = msg.getData().getString("url");

                if (msg.what == 1) {

                    if (url.equals("proc_get_dlg_alarm_list")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        alarmItems = new Gson().fromJson(result_item, new TypeToken<ArrayItem<AlarmData>>() {
                        }.getType());

                        if (alarmItems.isSuccess()) {
                            mc_airlineTV.setText("[ " + alarmItems.getArrayitem().get(0).getMcAirline() + " ]");
                            cp_nameTV.setText(alarmItems.getArrayitem().get(0).getCpName());
                            dlg_pd_nameTV.setText(alarmItems.getArrayitem().get(0).getPdName());
                            adapter.addItem(alarmItems.getArrayitem());

                        } else {
                            Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                            dismiss();
                        }
                    } else if (url.equals("proc_admin_get_machine_with_mac")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();

                        ArrayItem<MachineItem> machineItem = new Gson().fromJson(result_item, new TypeToken<ArrayItem<MachineItem>>() {
                        }.getType());

                        if (result_item.get("resultItem").getAsJsonObject().get("result").getAsString().equals("Y")) {
                            MonitoringDialog dialog = new MonitoringDialog(getContext(), type, machineItem.get(0), time);
                            dialog.show();

                        } else {
                            Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                        }
                    } else if (url.equals("proc_get_dlg_alarm_list2")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        alarmItems = new Gson().fromJson(result_item, new TypeToken<ArrayItem<AlarmData>>() {
                        }.getType());

                        if (alarmItems.isSuccess()) {
                            mc_airlineTV.setText("[ " + alarmItems.getArrayitem().get(0).getMcAirline() + " ]");
                            cp_nameTV.setText(alarmItems.getArrayitem().get(0).getCpName());
                            dlg_pd_nameTV.setText(alarmItems.getArrayitem().get(0).getPdName());
                            adapter.addItem(alarmItems.getArrayitem());

                        } else {
                            Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                            dismiss();
                        }
                    }

                } else {
                    Toast.makeText(getContext(), msg.obj.toString(), Toast.LENGTH_SHORT).show();
                }
            }
        };
    }
}





