package kr.co.compcarecompany.Util.CustomView;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.RelayData;
import kr.co.compcarecompany.R;

public class MyCanvas extends View {

    Paint m_Paint;
    Path m_Path;
    Canvas m_Canvas;
    ArrayList<RelayData> relay_array;
    ArrayList<Integer> relay_index = new ArrayList<>();

    int start_height = 0;
    int end_height = 0;

    Rect[] rects = new Rect[70];
    int rect_cnt = 0;

    private int mViewWidth = 0;
    private int mViewHeight = 0;

    //클릭 리스너
    public MyCanvas.chartClickListener chartClickListener;

    public interface chartClickListener {
        void clickBtn(Bundle bundle);
    }

    public MyCanvas(Context context) {
        super(context);
        initMyView();
    }

    public MyCanvas(Context context, ArrayList<RelayData> relay_array, MyCanvas.chartClickListener chartClickListener) {
        super(context);
        this.relay_array = relay_array;
        this.chartClickListener = chartClickListener;
        initMyView();
    }

    public void initMyView() {
        m_Paint = new Paint();
        m_Paint.setAntiAlias(true);
        m_Paint.setDither(true);
        m_Paint.setColor(getContext().getResources().getColor(R.color.light_blue));
        m_Paint.setStyle(Paint.Style.FILL);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        mViewWidth = MeasureSpec.getSize(widthMeasureSpec);
        mViewHeight = MeasureSpec.getSize(heightMeasureSpec);
        setMeasuredDimension(mViewWidth, mViewHeight);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        m_Canvas = canvas;

        int[] paint_colors = new int[]{getContext().getResources().getColor(R.color.schedule1), getContext().getResources().getColor(R.color.schedule2),
                getContext().getResources().getColor(R.color.schedule3), getContext().getResources().getColor(R.color.schedule4), getContext().getResources().getColor(R.color.schedule5),
                getContext().getResources().getColor(R.color.schedule6) , getContext().getResources().getColor(R.color.schedule7)};
        int cnt = 0;

        for (int i = 0; i < relay_array.size(); i++) {

            int s_day = Integer.parseInt(relay_array.get(i).getRsStartDay());
            int e_day = Integer.parseInt(relay_array.get(i).getRsEndDay());
            int s_height = Integer.parseInt(relay_array.get(i).getRsStartTime().substring(0, 2)) * 60 + Integer.parseInt(relay_array.get(i).getRsStartTime().substring(3, 5));
            int e_height = Integer.parseInt(relay_array.get(i).getRsEndTime().substring(0, 2)) * 60 + Integer.parseInt(relay_array.get(i).getRsEndTime().substring(3, 5));
            Rect rect1 = null;
            Rect rect2 = null;
            Rect rect3 = null;

            if (s_day == e_day) {
                rect1 = new Rect(mViewWidth * s_day / 7, mViewHeight * s_height / 1440, mViewWidth * (s_day + 1) / 7, mViewHeight * e_height / 1440);

            } else {
                rect2 = new Rect(mViewWidth * s_day / 7, mViewHeight * s_height / 1440, mViewWidth * (s_day + 1) / 7, mViewHeight);
                rect3 = new Rect(mViewWidth * e_day / 7, 0, mViewWidth * (e_day + 1) / 7, mViewHeight * e_height / 1440);
            }


            m_Paint.setColor(paint_colors[s_day]);

            if (rect1 != null && rect_cnt < rects.length) {
                canvas.drawRect(rect1, m_Paint);
                rects[rect_cnt] = rect1;
                relay_index.add(i);
                rect_cnt++;
            }

            if (rect2 != null && rect_cnt < rects.length) {
                canvas.drawRect(rect2, m_Paint);
                rects[rect_cnt] = rect2;
                relay_index.add(i);
                rect_cnt++;
            }

            if (rect3 != null && rect_cnt < rects.length) {
                canvas.drawRect(rect3, m_Paint);
                rects[rect_cnt] = rect3;
                relay_index.add(i);
                rect_cnt++;
            }
            cnt++;
            if (cnt > 4) {
                cnt = 0;
            }
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {

        final int action = event.getAction();

        if (action == MotionEvent.ACTION_DOWN) {
            final float x = event.getX();
            final float y = event.getY();

            for (int i = 0; i < relay_index.size(); i++) {
                if (rects[i].left <= x && rects[i].right >= x && rects[i].top <= y && rects[i].bottom >= y) {
                    Bundle bundle = new Bundle();
                    bundle.putSerializable("schedule_info", relay_array.get(relay_index.get(i)));
                    chartClickListener.clickBtn(bundle);
                    break;
                }
            }
        }

        return super.onTouchEvent(event);
    }
}