package kr.co.compcarecompany.Activity;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.widget.FrameLayout;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Company.CompanyData;
import kr.co.compcarecompany.Data.Product.RelayData;
import kr.co.compcarecompany.Fragment.Join.Find_Password_Fragment;
import kr.co.compcarecompany.Fragment.Main.Add_Machine_Fragment;
import kr.co.compcarecompany.Fragment.Join.Join_Step_First_Fragment;
import kr.co.compcarecompany.Fragment.Join.Join_Step_Second_Fragment;
import kr.co.compcarecompany.Fragment.Main.Company_Management_Fragment;
import kr.co.compcarecompany.Fragment.Main.Help_Service_Fragment;
import kr.co.compcarecompany.Fragment.Main.Machine_Management_Fragment;
import kr.co.compcarecompany.Fragment.Main.Alarm_Report_Fragment;
import kr.co.compcarecompany.Fragment.Main.Machine_Alarm_Fragment;
import kr.co.compcarecompany.Fragment.Main.Main_Menu_Fragment;
import kr.co.compcarecompany.Fragment.Main.Member_Info_Fragment;
import kr.co.compcarecompany.Fragment.Main.Member_Management_Fragment;
import kr.co.compcarecompany.Fragment.Main.Monitoring_Compare_Fragment;
import kr.co.compcarecompany.Fragment.Main.Monitoring_Report_Fragment;
import kr.co.compcarecompany.Fragment.Main.Option_Interlock_Fragment;
import kr.co.compcarecompany.Fragment.Main.Option_IoT_Fragment;
import kr.co.compcarecompany.Fragment.Main.Option_Machine_Fragment;
import kr.co.compcarecompany.Fragment.Main.Password_Setting_Fragment;
import kr.co.compcarecompany.Fragment.Main.Report_Publish_Fragment;
import kr.co.compcarecompany.Fragment.Main.Report_Publish_Setting_Fragment;
import kr.co.compcarecompany.Fragment.Menu.Place_Modify_Fragment;
import kr.co.compcarecompany.Fragment.Menu.Service_registration_Fragment;
import kr.co.compcarecompany.Fragment.Main.Service_List_Fragment;
import kr.co.compcarecompany.Fragment.Relay_Schedule2_Fragment;
import kr.co.compcarecompany.Fragment.Relay_Schedule_Fragment;
import kr.co.compcarecompany.MyApplication;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class FragmentActivity extends ActivityBasic {

    String Title = "";
    Fragment fragment;
    String type;
    FrameLayout frame;

    @Override
    protected void init() {

        Intent intent = getIntent();
        frame = findViewById(R.id.frame);

        switch (type) {

            /** 회원가입_1*/
            case "join_step_first":
                fragment = new Join_Step_First_Fragment(handler, intent.getBundleExtra("value1"));
                break;

            /** 회원가입_2*/
            case "join_step_second":
                fragment = new Join_Step_Second_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;

            /** 메뉴*/
            case "main_menu":
                Intent menu_intent = getIntent();
                fragment = new Main_Menu_Fragment(handler, intent.getStringExtra("value1"), (CompanyData) menu_intent.getSerializableExtra("value2"));
                break;

            /**장소정보 수정*/
            case "place_adjust":
                Intent place_intent = getIntent();
                fragment = new Place_Modify_Fragment(handler, (CompanyData) place_intent.getSerializableExtra("value1"));
                break;

            /**서비스 접수*/
            case "service_registration":
                Intent service_intent = getIntent();
                fragment = new Service_registration_Fragment(handler, (CompanyData) service_intent.getSerializableExtra("value1"));
                break;

            /**기계보안**/
            case "password_setting":
                fragment = new Password_Setting_Fragment(handler, intent.getStringExtra("value1"));
                break;

            /**알림현황**/
            case "machine_alarm":
                fragment = new Machine_Alarm_Fragment(handler);
                break;

            /**작업일지**/
            case "alarm_report":
                fragment = new Alarm_Report_Fragment(handler, intent.getStringArrayListExtra("value1"), intent.getStringExtra("value2"));
                break;

            /**서비스 현황**/
            case "service_list":
                Intent service_list_intent = getIntent();
                fragment = new Service_List_Fragment(handler, (CompanyData) service_list_intent.getSerializableExtra("value1"));
                break;

            /**머신 등록**/
            case "add_machine":
                fragment = new Add_Machine_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;

            /**원격운전 스케줄**/
            case "relay_schedule":
                fragment = new Relay_Schedule2_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;

            /**원격운전 스케줄**/
            case "relay_schedule2":
                Intent relay_intent = getIntent();
                ArrayList<RelayData> list = (ArrayList<RelayData>) relay_intent.getSerializableExtra("value1");
                fragment = new Relay_Schedule_Fragment(handler, list);
                break;

            /**기계관리**/
            case "machine_management":
                fragment = new Machine_Management_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;

            /**내 정보**/
            case "member_info":
                fragment = new Member_Info_Fragment(handler);
                break;

            /**데이터분석>단일분석>주간,월간**/
            case "monitoring_report":
                fragment = new Monitoring_Report_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("select_type"), intent.getStringExtra("year"),
                        intent.getStringExtra("month"), intent.getStringExtra("week"), intent.getStringExtra("cp_name"));
                break;

            /**데이터분석>단일분석>기간, 일간**/
            case "monitoring_report2":
                fragment = new Monitoring_Report_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("select_type"), intent.getStringExtra("start_date"),
                        intent.getStringExtra("end_date"), intent.getStringExtra("cp_name"));
                break;

            /**지점 관리**/
            case "company_management":
                fragment = new Company_Management_Fragment(handler);
                break;

            /**옵션-기계설정**/
            case "option_machine":
                fragment = new Option_Machine_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;

            /**옵셤-IoT설정**/
            case "option_iot":
                fragment = new Option_IoT_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"), intent.getStringExtra("value4"));
                break;

            /**옵셤-연동제어설정**/
            case "option_interlock":
                fragment = new Option_Interlock_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;

            /**멤버 관리**/
            case "member_management":
                fragment = new Member_Management_Fragment(handler);
                break;

            /**비밀번호 찾기**/
            case "find_password":
                fragment = new Find_Password_Fragment(handler);
                break;

            /**데이터분석>다중비교**/
            case "monitoring_compare":
                fragment = new Monitoring_Compare_Fragment(handler, intent.getStringArrayListExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;

            /**데이터분석>정기발행설정**/
            case "report_publish_setting":
                fragment = new Report_Publish_Setting_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;

            /**정기발행**/
            case "report_publish":
                fragment = new Report_Publish_Fragment(handler, intent.getStringExtra("value1"));
                break;

            /**도움말**/
            case "help_service":
                fragment = new Help_Service_Fragment(handler);
                break;
        }

        callFragment(fragment, frame);
    }

    @Override
    protected void init_Listener() {

    }

    @Override
    protected void getMessage(Message msg) {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Intent intent = getIntent();
        Title = intent.getStringExtra("title");
        type = intent.getStringExtra("type");
        MyApplication.myActivity = this;
        setContentView(R.layout.activity_fragment, Title);
        super.onCreate(savedInstanceState);
    }

    void callFragment(Fragment fragment, FrameLayout frame) {

        getSupportFragmentManager()
                .beginTransaction()
                .replace(frame.getId(), fragment)
                .commit();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onBackPressed() {

        if (type.contains("option_")) {

            AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(context);
            dialogBuilder.setTitle("콤프케어 작업자");
            if (type.contains("iot")) dialogBuilder.setMessage("메인으로 나가시겠습니까?");
            else dialogBuilder.setMessage("옵션 내역을 저장하지 않았습니다.\n메인으로 나가시겠습니까?");
            dialogBuilder.setPositiveButton("팝업 창 닫기", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int i) {
                    dialog.dismiss();
                }
            });

            dialogBuilder.setNeutralButton("나가기", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    finish();
                }
            });
            dialogBuilder.show();

        } else if (type.contains("company_management")) {
            Common.getInstance().toastShow(context, "지점 정보를 새롭게 불러옵니다...");
            super.onBackPressed();

        } else if (type.contains("member_management") && (userItem.getArrayitem().getMbActivatedList() == null || userItem.getArrayitem().getMbActivatedList().size() < 1)) {
            AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(context);
            dialogBuilder.setTitle("콤프케어 작업자");
            dialogBuilder.setMessage("등록된 멤버가 전부 차단되었습니다.\n로그아웃 시 접속이 제한될 수 있습니다.\n화면을 나가시겠습니까?");
            dialogBuilder.setPositiveButton("확인", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int i) {
                    dialog.dismiss();
                    finish();
                }
            });

            dialogBuilder.setNeutralButton("취소", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            dialogBuilder.show();
        } else {
            super.onBackPressed();
        }
    }
}
