package kr.co.compcarecompany.Activity;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import kr.co.compcarecompany.MyApplication;
import kr.co.compcarecompany.R;

public class PopupActivity  extends AppCompatActivity {
    String type, message;
    TextView contents;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_pop_up);

        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));

        MyApplication.myActivity = this;
        contents = findViewById(R.id.contents);

        Intent i = getIntent();
        type = i.getStringExtra("type");
        message = i.getStringExtra("message");

        contents.setText(message);

        // 이 부분이 바로 화면을 깨우는 부분 되시겠다.
        // 화면이 잠겨있을 때 보여주기
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED
                // 키잠금 해제하기
                | WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD
                // 화면 켜기
                | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
        Button ok = findViewById(R.id.ok);

        MyApplication application = (MyApplication) getApplication();

        ok.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                /*Intent intent = null;

                if (application.isRuuningApp){
                    if (i.getBooleanExtra("isMain", false) == false){
                        intent = new Intent(PopupActivity.this, MainActivity.class)
                                .addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
                        startActivity(intent);
                    }
                }else{
                    if (type.equals("background")){
                        Log.d("isBackground?", "true");
                        intent = new Intent(PopupActivity.this, Intro.class);
                        startActivity(intent);
                    }else{
                        Log.d("isBackground?", "false");
                        Log.d("1234", i.getBooleanExtra("isMain", false) + "");
                        if (i.getBooleanExtra("isMain", false) == false){
                            intent = new Intent(PopupActivity.this, MainActivity.class)
                                    .addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
                            startActivity(intent);
                        }
                    }
                }*/

                startActivity(new Intent(PopupActivity.this, Intro.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                finishAffinity();
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        NotificationManager notifiyMgr = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        notifiyMgr.cancelAll();
    }
}