package kr.co.compcarecompany.Data.Product;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class MonitoringData implements Parcelable {
    @SerializedName("time")
    @Expose
    private String time;

    @SerializedName("temp_ntc")
    @Expose
    private String tempNtc;

    @SerializedName("temp_ntc_2")
    @Expose
    private String tempNtc2;

    @SerializedName("temp_ntc_max")
    @Expose
    private String tempNtcMax;

    @SerializedName("temp_ntc_2_max")
    @Expose
    private String tempNtc2Max;

    @SerializedName("temp_pt100")
    @Expose
    private String tempPt100;

    @SerializedName("temp_pt100_max")
    @Expose
    private String tempPt100Max;

//    @SerializedName("temp_pt100_2_max")
//    @Expose
//    private String tempPt1002Max;
//
//    @SerializedName("temp_pt100_3_max")
//    @Expose
//    private String tempPt1003Max;

    @SerializedName("current1")
    @Expose
    private String current1;

    @SerializedName("current1_max")
    @Expose
    private String current1Max;

    @SerializedName("current2")
    @Expose
    private String current2;

    @SerializedName("current2_max")
    @Expose
    private String current2Max;

    @SerializedName("current3")
    @Expose
    private String current3;

    @SerializedName("current3_max")
    @Expose
    private String current3Max;

    @SerializedName("pressure1")
    @Expose
    private String pressure1;

    @SerializedName("pressure1_max")
    @Expose
    private String pressure1Max;

    @SerializedName("pressure2")
    @Expose
    private String pressure2;

    @SerializedName("pressure2_max")
    @Expose
    private String pressure2Max;

    @SerializedName("pressure3")
    @Expose
    private String pressure3;

    @SerializedName("pressure3_max")
    @Expose
    private String pressure3Max;

    @SerializedName("MAC")
    @Expose
    private String MAC;

    @SerializedName("running")
    @Expose
    private String running;

    @SerializedName("real_time")
    @Expose
    private String realTime;

    @SerializedName("remote1")
    @Expose
    private String remote1;

    @SerializedName("eco_stop")
    @Expose
    private String ecoStop;

    @SerializedName("schedule_mode")
    @Expose
    private String scheduleMode;

    @SerializedName("pressure_time")
    @Expose
    private String pressureTime;

    @SerializedName("relay2_time")
    @Expose
    private String relay2Time;

    @SerializedName("rpm")
    @Expose
    private String rpm;

    @SerializedName("rpm_max")
    @Expose
    private String rpmMax;

    @SerializedName("rpm_min")
    @Expose
    private String rpmMin;

    @SerializedName("std_current")
    @Expose
    private String stdCurrent;

    @SerializedName("opt1_cnt")
    @Expose
    private String opt1Cnt;

    @SerializedName("opt2_cnt")
    @Expose
    private String opt2Cnt;

    @SerializedName("opt3_cnt")
    @Expose
    private String opt3Cnt;

    @SerializedName("opt4_cnt")
    @Expose
    private String opt4Cnt;

    @SerializedName("opt5_cnt")
    @Expose
    private String opt5Cnt;

    @SerializedName("opt6_cnt")
    @Expose
    private String opt6Cnt;

    @SerializedName("opt7_cnt")
    @Expose
    private String opt7Cnt;

    @SerializedName("relay1_val")
    @Expose
    private String relay1Val;

    @SerializedName("pressure_max")
    @Expose
    private String pressureMax;

    @SerializedName("pressure_min")
    @Expose
    private String pressureMin;

    @SerializedName("inverter_error")
    @Expose
    private String inverterError;

    @SerializedName("power_error")
    @Expose
    private String powerError;

    @SerializedName("inverter_mode")
    @Expose
    private String inverterMode;

    @SerializedName("M1")
    @Expose
    private String M1;

    @SerializedName("M2")
    @Expose
    private String M2;

    @SerializedName("opt8_cnt")
    @Expose
    private String opt8Cnt;

    @SerializedName("power_consumption")
    @Expose
    private String powerConsumption;

    @SerializedName("mc_current1_up")
    @Expose
    private String mcCurrent1Up;
    @SerializedName("mc_current2_up")
    @Expose
    private String mcCurrent2Up;
    @SerializedName("mc_current3_up")
    @Expose
    private String mcCurrent3Up;

    @SerializedName("mc_pressure1_up")
    @Expose
    private String mcPressure1Up;
    @SerializedName("mc_pressure2_up")
    @Expose
    private String mcPressure2Up;
    @SerializedName("mc_pressure3_up")
    @Expose
    private String mcPressure3Up;

    @SerializedName("mc_temp_ntc_up")
    @Expose
    private String mcTempNtcUp;
    @SerializedName("mc_temp_ntc_2_up")
    @Expose
    private String mcTempNtc2Up;
    @SerializedName("mc_temp_pt_up")
    @Expose
    private String mcTempPtUp;
    @SerializedName("mc_temp_ntc_down")
    @Expose
    private String mcTempNtcDown;
    @SerializedName("mc_temp_ntc_2_down")
    @Expose
    private String mcTempNtc2Down;
    @SerializedName("mc_temp_pt_down")
    @Expose
    private String mcTempPtDown;

    @SerializedName("fan_motor_start_temp")
    @Expose
    private String fanMotorStartTemp;
    @SerializedName("fan_motor_stop_temp")
    @Expose
    private String fanMotorStopTemp;
    @SerializedName("fan_motor_delay_time")
    @Expose
    private String fanMotorDelayTime;
    @SerializedName("inverter_speed")
    @Expose
    private String inverterSpeed;
    @SerializedName("mc_sol_time")
    @Expose
    private String mcSolTime;
    @SerializedName("current_delay")
    @Expose
    private String currentDelay;
    @SerializedName("main_current_delay_time")
    @Expose
    private String mainCurrentDelayTime;

    @SerializedName("power_count")
    @Expose
    private String powerCount;

    @SerializedName("real_power_count")
    @Expose
    private String realPowerCount;

    @SerializedName("real_power_consumption")
    @Expose
    private String realPowerConsumption;

    //23.08.14
    @SerializedName("power_data")
    @Expose
    private String powerdata;

    //23.08.04
    @SerializedName("power_data_cnt")
    @Expose
    private String powerdatacnt;

    @SerializedName("sensor_cnt")
    @Expose
    private String sensorCnt;

    @SerializedName("power_consumption_sum")
    @Expose
    private String powerConsumptionSum;

    @SerializedName("cross_time_t")
    @Expose
    private String crossTimeT;

    @SerializedName("mc_yeon_type")
    @Expose
    private String mqttYeonType;


    @SerializedName("mc_pressure1_down")
    @Expose
    private String mcPressure1Down;
    @SerializedName("mc_pressure2_down")
    @Expose
    private String mcPressure2Down;
    @SerializedName("mc_pressure3_down")
    @Expose
    private String mcPressure3Down;

    public MonitoringData(String powerConsumption, String tempNtc, String tempNtc2,String tempPt100, String current1, String current2, String current3, String pressure1, String pressure2, String pressure3, String MAC) {
        this.powerConsumption = powerConsumption;
        this.tempNtc = tempNtc;
        this.tempNtc2 = tempNtc2;
        this.tempPt100 = tempPt100;
        this.current1 = current1;
        this.current2 = current2;
        this.current3 = current3;
        this.pressure1 = pressure1;
        this.pressure2 = pressure2;
        this.pressure3 = pressure3;
        this.MAC = MAC;
    }

    private MonitoringData(Parcel in) {
        time = in.readString();
        powerConsumption = in.readString();
        tempNtc = in.readString();
        tempNtc2 = in.readString();
        tempNtcMax = in.readString();
        tempNtc2Max = in.readString();
        tempPt100 = in.readString();
        tempPt100Max = in.readString();
        current1 = in.readString();
        current1Max = in.readString();
        current2 = in.readString();
        current2Max = in.readString();
        current3 = in.readString();
        current3Max = in.readString();
        pressure1 = in.readString();
        pressure1Max = in.readString();
        pressure2 = in.readString();
        pressure2Max = in.readString();
        pressure3 = in.readString();
        pressure3Max = in.readString();
        MAC = in.readString();
        running = in.readString();
        realTime = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(time);
        dest.writeString(powerConsumption);
        dest.writeString(tempNtc);
        dest.writeString(tempNtcMax);
        dest.writeString(tempNtc2);
        dest.writeString(tempNtc2Max);
        dest.writeString(tempPt100);
        dest.writeString(tempPt100Max);
        dest.writeString(current1);
        dest.writeString(current1Max);
        dest.writeString(current2);
        dest.writeString(current2Max);
        dest.writeString(current3);
        dest.writeString(current3Max);
        dest.writeString(pressure1);
        dest.writeString(pressure1Max);
        dest.writeString(pressure2);
        dest.writeString(pressure2Max);
        dest.writeString(pressure3);
        dest.writeString(pressure3Max);
        dest.writeString(MAC);
        dest.writeString(running);
        dest.writeString(realTime);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<MonitoringData> CREATOR = new Creator<MonitoringData>() {
        @Override
        public MonitoringData createFromParcel(Parcel in) {
            return new MonitoringData(in);
        }

        @Override
        public MonitoringData[] newArray(int size) {
            return new MonitoringData[size];
        }
    };

    public String getTime() {
        return time;
    }

    public String getTempNtc() {
        return tempNtc;
    }

    public String getTempNtcMax() {
        return tempNtcMax;
    }

    public String getTempPt100() {
        return tempPt100;
    }

    public String getTempPt100Max() {
        return tempPt100Max;
    }

    public String getCurrent1() {
        return current1;
    }

    public String getCurrent1Max() {
        return current1Max;
    }

    public String getCurrent2() {
        return current2;
    }

    public String getCurrent2Max() {
        return current2Max;
    }

    public String getCurrent3() {
        return current3;
    }

    public String getCurrent3Max() {
        return current3Max;
    }

    public String getPressure1() {
        return pressure1;
    }

    public String getPressure1Max() {
        return pressure1Max;
    }

    public String getPressure2() {
        return pressure2;
    }

    public String getPressure2Max() {
        return pressure2Max;
    }

    public String getPressure3() {
        return pressure3;
    }

    public String getPressure3Max() {
        return pressure3Max;
    }

    public String getMAC() {
        return MAC;
    }

    public void setTempNtc(String tempNtc) {
        this.tempNtc = tempNtc;
    }

    public void setTempPt100(String tempPt100) {
        this.tempPt100 = tempPt100;
    }

    public void setCurrent1(String current1) {
        this.current1 = current1;
    }

    public void setCurrent2(String current2) {
        this.current2 = current2;
    }

    public void setCurrent3(String current3) {
        this.current3 = current3;
    }

    public void setPressure1(String pressure1) {
        this.pressure1 = pressure1;
    }

    public void setPressure2(String pressure2) {
        this.pressure2 = pressure2;
    }

    public void setPressure3(String pressure3) {
        this.pressure3 = pressure3;
    }

    public String getRunning() {
        return running;
    }

    public String getRealTime() {
        return realTime;
    }

    public String getRemote1() {
        return remote1;
    }

    public void setRemote1(String remote1) {
        this.remote1 = remote1;
    }

    public String getEcoStop() {
        return ecoStop;
    }

    public String getScheduleMode() {
        return scheduleMode;
    }

    public String getPressureTime() {
        return pressureTime;
    }

    public String getRelay2Time() {
        return relay2Time;
    }

    public String getRpm() {
        return rpm;
    }

    public String getRpmMax() {
        return rpmMax;
    }

    public String getRpmMin() {
        return rpmMin;
    }

    public String getStdCurrent() {
        return stdCurrent;
    }

//    public String getTempPt1002Max() {
//        return tempPt1002Max;
//    }
//
//    public String getTempPt1003Max() {
//        return tempPt1003Max;
//    }

    public String getOpt1Cnt() {
        return opt1Cnt;
    }

    public String getOpt2Cnt() {
        return opt2Cnt;
    }

    public String getOpt3Cnt() {
        return opt3Cnt;
    }

    public String getOpt4Cnt() {
        return opt4Cnt;
    }

    public String getOpt5Cnt() {
        return opt5Cnt;
    }

    public String getOpt6Cnt() {
        return opt6Cnt;
    }

    public String getOpt7Cnt() {
        return opt7Cnt;
    }

    public String getPressureMax() {
        return pressureMax;
    }

    public String getPressureMin() {
        return pressureMin;
    }

    public String getRelay1Val() {
        return relay1Val;
    }

    public String getInverterError() {
        return inverterError;
    }

    public String getTempNtc2() {
        return tempNtc2;
    }

    public String getTempNtc2Max() {
        return tempNtc2Max;
    }

    public String getPowerError() {
        return powerError;
    }

    public String getInverterMode() {
        return inverterMode;
    }

    public String getM1() {
        return M1;
    }

    public String getM2() {
        return M2;
    }

    public String getOpt8Cnt() {
        return opt8Cnt;
    }

    public String getPowerConsumption() {
        return powerConsumption;
    }

    public String getMcCurrent1Up() {
        return mcCurrent1Up;
    }

    public String getMcCurrent2Up() {
        return mcCurrent2Up;
    }

    public String getMcCurrent3Up() {
        return mcCurrent3Up;
    }

    public String getMcPressure1Up() {
        return mcPressure1Up;
    }

    public String getMcPressure2Up() {
        return mcPressure2Up;
    }

    public String getMcPressure3Up() {
        return mcPressure3Up;
    }

    public String getMcTempNtcUp() {
        return mcTempNtcUp;
    }

    public String getMcTempNtc2Up() {
        return mcTempNtc2Up;
    }

    public String getMcTempPtUp() {
        return mcTempPtUp;
    }

    public String getMcTempNtcDown() {
        return mcTempNtcDown;
    }

    public String getMcTempNtc2Down() {
        return mcTempNtc2Down;
    }

    public String getMcTempPtDown() {
        return mcTempPtDown;
    }

    public String getFanMotorStartTemp() {
        return fanMotorStartTemp;
    }

    public String getFanMotorStopTemp() {
        return fanMotorStopTemp;
    }

    public String getFanMotorDelayTime() {
        return fanMotorDelayTime;
    }

    public String getInverterSpeed() {
        return inverterSpeed;
    }

    public String getMcSolTime() {
        return mcSolTime;
    }

    public String getCurrentDelay() {
        return currentDelay;
    }

    public String getMainCurrentDelayTime() {
        return mainCurrentDelayTime;
    }

    public String getPowerCount() {
        return powerCount;
    }

    public String getRealPowerCount() {
        return realPowerCount;
    }

    public String getRealPowerConsumption() {
        return realPowerConsumption;
    }

    public String getPowerdata() {
        return powerdata;
    }

    public String getPowerDataCnt() {
        return powerdatacnt;
    }

    public String getSensorCnt() {
        return sensorCnt;
    }

    public String getPowerConsumptionSum() {
        return powerConsumptionSum;
    }

    public String getCrossTimeT() {
        return crossTimeT;
    }

    public String getMqttYeonType() {
        return mqttYeonType;
    }

    public String getMcPressure1Down() {
        return mcPressure1Down;
    }

    public String getMcPressure2Down() {
        return mcPressure2Down;
    }

    public String getMcPressure3Down() {
        return mcPressure3Down;
    }



}
