package kr.co.compcarecompany.Fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import java.util.ArrayList;

import kr.co.compcarecompany.Activity.FragmentActivity;
import kr.co.compcarecompany.Data.Product.RelayData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.CustomView.MyCanvas;
import kr.co.compcarecompany.Util.CustomView.ScheduleDetailDialog;

public class Relay_Schedule_Fragment extends Fragment {

    private Handler handler;
    private FragmentActivity fa;

    private RelativeLayout totalRL;
    private LinearLayout totalLL;
    private ArrayList<RelayData> relayData;
    private FrameLayout sunFL;
    private ScaleGestureDetector scaleGestureDetector;
    private float scale_factor = 1.0f;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        fa = (FragmentActivity) getActivity();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        fa = null;
    }

    @SuppressLint("ValidFragment")
    public Relay_Schedule_Fragment(Handler handler, ArrayList<RelayData> relayData) {
        this.handler = handler;
        this.relayData = relayData;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.frag_relay_schedule, container, false);

        sunFL = v.findViewById(R.id.sunFL);
        totalRL = v.findViewById(R.id.totalRL);
        totalLL = v.findViewById(R.id.totalLL);

        init_Listener();
        return v;
    }

    public void init_Listener() {

        MyCanvas sun_canvas = new MyCanvas(getContext(), relayData, new MyCanvas.chartClickListener() {
            @Override
            public void clickBtn(Bundle bundle) {

                RelayData relayData = (RelayData) bundle.get("schedule_info");
                ScheduleDetailDialog detailDialog = new ScheduleDetailDialog(getContext(), handler, relayData);
                detailDialog.show();
            }
        });

        sunFL.addView(sun_canvas);
    }

    private class ScaleListener extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        @Override
        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            // ScaleGestureDetector에서 factor를 받아 변수로 선언한 factor에 넣고
            scale_factor *= scaleGestureDetector.getScaleFactor();

            // 최대 10배, 최소 10배 줌 한계 설정
            scale_factor = Math.max(0.5f,
                    Math.min(scale_factor, 3.0f));

            // 스케일 적용
            totalRL.setScaleX(scale_factor);
            totalRL.setScaleY(scale_factor);
            return true;
        }
    }
}