package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.R;

public class AlarmRemoveListAdapter extends RecyclerView.Adapter<AlarmRemoveListAdapter.ItemViewHolder> {

    Context context;
    Handler handler;

    private ArrayList<AlarmData> items = new ArrayList<>();

    public AlarmRemoveListAdapter(@NonNull Context context) {
        this.context = context;
    }

    @NonNull
    @Override
    public AlarmRemoveListAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_alarm_remove_list, viewGroup, false);

        return new AlarmRemoveListAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull AlarmRemoveListAdapter.ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<AlarmData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView alarm_push_timeTV, alarm_sensorTV, alarm_remove_timeTV, alarm_remove_mb_nameTV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            alarm_push_timeTV = itemView.findViewById(R.id.alarm_push_timeTV);
            alarm_sensorTV = itemView.findViewById(R.id.alarm_sensorTV);
            alarm_remove_timeTV = itemView.findViewById(R.id.alarm_remove_timeTV);
            alarm_remove_mb_nameTV = itemView.findViewById(R.id.alarm_remove_mb_nameTV);
        }

        void onBind(AlarmData data) {

            alarm_push_timeTV.setText(data.getPushDt().substring(2));
            alarm_remove_timeTV.setText(data.getReadTime().substring(2));
            if (data.getMbName() != null) alarm_remove_mb_nameTV.setText(data.getMbName());
            else alarm_remove_mb_nameTV.setText("-");

            String type = "";
            switch (data.getSensor()) {

                case "1":
                    type = "전류1";
                    break;
                case "2":
                    type = "전류2";
                    break;
                case "3":
                    type = "전류3";
                    break;
                case "4":
                case "10":
                    type = "압력1";
                    break;
                case "5":
                case "11":
                    type = "압력2";
                    break;
                case "6":
                case "12":
                    type = "압력3";
                    break;
                case "7":
                    type = "온도NTC";
                    break;
                case "8":
                    type = "온도PT100";
                    break;
                case "9":
                    type = "온도NTC_2";
                    break;
            }

            alarm_sensorTV.setText(type);

        }
    }
}
