package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;

import kr.co.compcarecompany.Activity.MainActivity;
import kr.co.compcarecompany.Activity.WebviewAct;
import kr.co.compcarecompany.Data.Company.CompanyData;
import kr.co.compcarecompany.Data.Product.AlMachineDatum;
import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.MyApplication;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Api.ApiClient;
import kr.co.compcarecompany.Util.CustomView.AddAirLineDialog;
import kr.co.compcarecompany.Util.CustomView.AddPlaceDialog;
import kr.co.compcarecompany.Util.CustomView.AirLineModifyDialog;

public class CompanyManagementAdapter extends RecyclerView.Adapter<CompanyManagementAdapter.ItemViewHolder> {

    private Context context;
    private Handler handler;

    // adapter에 들어갈 list 입니다.
    private ArrayList<CompanyData> items = new ArrayList<>();

    private CompanyManagementAdapter.cp_modifyClickListener cp_modifyClickListener;

    public interface cp_modifyClickListener {
        void clickBtn();
    }

    private CompanyManagementAdapter.cp_delClickListener cp_delClickListener;

    public interface cp_delClickListener {
        void clickBtn(String cp_idx);
    }

    private CompanyManagementAdapter.airline_modifyClickListener airline_modifyClickListener;

    public interface airline_modifyClickListener {
        void clickBtn();
    }

    public CompanyManagementAdapter(Context context, Handler handler, CompanyManagementAdapter.cp_modifyClickListener cp_modifyClickListener, CompanyManagementAdapter.cp_delClickListener cp_delClickListener,
                                    CompanyManagementAdapter.airline_modifyClickListener airline_modifyClickListener) {
        this.context = context;
        this.handler = handler;
        this.cp_modifyClickListener = cp_modifyClickListener;
        this.cp_delClickListener = cp_delClickListener;
        this.airline_modifyClickListener = airline_modifyClickListener;
    }

    @NonNull
    @Override
    public CompanyManagementAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_company_management, parent, false);
        return new CompanyManagementAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull CompanyManagementAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));

        holder.cp_manage_cp_modifyIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                AddPlaceDialog dialog = new AddPlaceDialog(context, handler, items.get(position).getAgIdx(), items.get(position).getPtIdx(), position);
                dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialogInterface) {
                        cp_modifyClickListener.clickBtn();
                    }
                });
                dialog.show();
            }
        });

        holder.cp_manage_cp_delIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                cp_delClickListener.clickBtn(items.get(position).getCpIdx());
            }
        });

        holder.cp_manage_cp_airline_modifyIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                String airline [] = new String[]{};
                if (items.get(position).getCpAirline() != null) {
                    airline = items.get(position).getCpAirline().toString().split(",");
                }
                AirLineModifyDialog dialog = new AirLineModifyDialog(context, handler, items.get(position).getAgIdx(), items.get(position).getCpIdx(), airline, new AirLineModifyDialog.clickListener() {
                    @Override
                    public void clickBtn() {
                        airline_modifyClickListener.clickBtn();
                    }
                });
                dialog.show();
            }
        });
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    public void addItem(ArrayList<CompanyData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView cp_manage_nameTV, cp_manage_cp_addrTV, cp_manage_cp_addr_subTV, cp_manage_cp_airlineTV;
        ImageView cp_manage_cp_delIV, cp_manage_cp_modifyIV, cp_manage_cp_airline_modifyIV;

        ItemViewHolder(View itemView) {
            super(itemView);
            cp_manage_nameTV = itemView.findViewById(R.id.cp_manage_nameTV);
            cp_manage_cp_addrTV = itemView.findViewById(R.id.cp_manage_cp_addrTV);
            cp_manage_cp_addr_subTV = itemView.findViewById(R.id.cp_manage_cp_addr_subTV);
            cp_manage_cp_airlineTV = itemView.findViewById(R.id.cp_manage_cp_airlineTV);
            cp_manage_cp_delIV = itemView.findViewById(R.id.cp_manage_cp_delIV);
            cp_manage_cp_modifyIV = itemView.findViewById(R.id.cp_manage_cp_modifyIV);
            cp_manage_cp_airline_modifyIV = itemView.findViewById(R.id.cp_manage_cp_airline_modifyIV);

        }

        void onBind(CompanyData data) {

            cp_manage_nameTV.setText(data.getCpName());
            if (data.getCpName().equals("본사")) cp_manage_cp_delIV.setVisibility(View.GONE);
            cp_manage_cp_addrTV.setText(data.getCpAddr());
            cp_manage_cp_addr_subTV.setText(data.getCpAddrSub());
            if(data.getCpAirline() != null) {
                cp_manage_cp_airlineTV.setText(data.getCpAirline().toString());
            } else {
                cp_manage_cp_airlineTV.setText("기본값");
            }

        }
    }
}

