package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Activity.FragmentActivity;
import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.R;

public class MachineManagementContentAdapter extends RecyclerView.Adapter<MachineManagementContentAdapter.ItemViewHolder> {

    private Context context;
    private Handler handler;
    private FragmentActivity frag;

    private MachineManagementContentAdapter.alarmClickListener alarmClickListener;

    public interface alarmClickListener {
        void clickBtn(Bundle bundle);
    }

    private MachineManagementContentAdapter.reportClickListener reportClickListener;

    public interface reportClickListener {
        void clickBtn(Bundle bundle);
    }

    private MachineManagementContentAdapter.returnClickListener returnClickListener;

    public interface returnClickListener {
        void clickBtn();
    }

    private MachineManagementContentAdapter.detailClickListener detailClickListener;

    public interface detailClickListener {
        void clickBtn(Bundle bundle);
    }

    private ArrayList<AlarmData> items = new ArrayList<>();

    public MachineManagementContentAdapter(@NonNull Context context, Handler handler, FragmentActivity frag, MachineManagementContentAdapter.alarmClickListener alarmClickListener, MachineManagementContentAdapter.reportClickListener reportClickListener
            , MachineManagementContentAdapter.returnClickListener returnClickListener, MachineManagementContentAdapter.detailClickListener detailClickListener) {
        this.context = context;
        this.handler = handler;
        this.frag = frag;
        this.alarmClickListener = alarmClickListener;
        this.reportClickListener = reportClickListener;
        this.returnClickListener = returnClickListener;
        this.detailClickListener = detailClickListener;
    }

    @NonNull
    @Override
    public MachineManagementContentAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_machine_management_content, viewGroup, false);
        return new MachineManagementContentAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MachineManagementContentAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        if (items.get(position).getCtReports() != null) {
            MachineManagementReportAdapter detailAdapter = new MachineManagementReportAdapter(context, handler, frag.userItem.getArrayitem().getAgIdx(), frag.userItem.getArrayitem().getPtIdx(), frag.userItem.getArrayitem().getMbId(), frag);
            itemViewHolder.current_listRV.setAdapter(detailAdapter);
            detailAdapter.addItem(items.get(position).getCtReports());
        }

        if (items.get(position).getCtAlarms() != null) {
            MachineManagementDetailAdapter detailAdapter = new MachineManagementDetailAdapter(new MachineManagementDetailAdapter.detailClickListener() {
                @Override
                public void clickBtn(Bundle bundle) {
                    detailClickListener.clickBtn(bundle);
                }
            });
            itemViewHolder.current_listRV.setAdapter(detailAdapter);
            detailAdapter.addItem(items.get(position).getCtAlarms());
        }

        if (items.get(position).getPrReports() != null) {
            MachineManagementReportAdapter detailAdapter = new MachineManagementReportAdapter(context, handler, frag.userItem.getArrayitem().getAgIdx(), frag.userItem.getArrayitem().getPtIdx(), frag.userItem.getArrayitem().getMbId(), frag);
            itemViewHolder.pressure_listRV.setAdapter(detailAdapter);
            detailAdapter.addItem(items.get(position).getPrReports());
        }

        if (items.get(position).getPrAlarms() != null) {
            MachineManagementDetailAdapter detailAdapter = new MachineManagementDetailAdapter(new MachineManagementDetailAdapter.detailClickListener() {
                @Override
                public void clickBtn(Bundle bundle) {
                    detailClickListener.clickBtn(bundle);
                }
            });
            itemViewHolder.pressure_listRV.setAdapter(detailAdapter);
            detailAdapter.addItem(items.get(position).getPrAlarms());
        }

        if (items.get(position).getPrMinAlarms() != null) {
            MachineManagementDetailAdapter detailAdapter = new MachineManagementDetailAdapter(new MachineManagementDetailAdapter.detailClickListener() {
                @Override
                public void clickBtn(Bundle bundle) {
                    detailClickListener.clickBtn(bundle);
                }
            });
            itemViewHolder.pressure_min_listRV.setAdapter(detailAdapter);
            detailAdapter.addItem(items.get(position).getPrMinAlarms());
        }

        if (items.get(position).getTempReports() != null) {
            MachineManagementReportAdapter detailAdapter = new MachineManagementReportAdapter(context, handler, frag.userItem.getArrayitem().getAgIdx(), frag.userItem.getArrayitem().getPtIdx(), frag.userItem.getArrayitem().getMbId(), frag);
            itemViewHolder.temper_listRV.setAdapter(detailAdapter);
            detailAdapter.addItem(items.get(position).getTempReports());
        }

        if (items.get(position).getTempAlarms() != null) {
            MachineManagementDetailAdapter detailAdapter = new MachineManagementDetailAdapter(new MachineManagementDetailAdapter.detailClickListener() {
                @Override
                public void clickBtn(Bundle bundle) {
                    detailClickListener.clickBtn(bundle);
                }
            });
            itemViewHolder.temper_listRV.setAdapter(detailAdapter);
            detailAdapter.addItem(items.get(position).getTempAlarms());
        }

        if (items.get(position).getServiceReports() != null) {
            MachineManagementReportAdapter detailAdapter = new MachineManagementReportAdapter(context, handler, frag.userItem.getArrayitem().getAgIdx(), frag.userItem.getArrayitem().getPtIdx(), frag.userItem.getArrayitem().getMbId(), frag);
            itemViewHolder.service_listRV.setAdapter(detailAdapter);
            detailAdapter.addItem(items.get(position).getServiceReports());
        }
//
//        //전류 레이아웃 접고 펼치기
//        itemViewHolder.current_extendIV.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                if (itemViewHolder.current_contentLL.getVisibility() == View.VISIBLE) {
//                    itemViewHolder.current_extendIV.setImageResource(R.drawable.arrow_down);
//                    itemViewHolder.current_contentLL.setVisibility(View.GONE);
//                } else {
//                    itemViewHolder.current_extendIV.setImageResource(R.drawable.arrow_up);
//                    itemViewHolder.current_contentLL.setVisibility(View.VISIBLE);
//                }
//            }
//        });
//        //압력 레이아웃 접고 펼치기
//        itemViewHolder.pressure_extendIV.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                if (itemViewHolder.pressure_contentLL.getVisibility() == View.VISIBLE) {
//                    itemViewHolder.pressure_extendIV.setImageResource(R.drawable.arrow_down);
//                    itemViewHolder.pressure_contentLL.setVisibility(View.GONE);
//                } else {
//                    itemViewHolder.pressure_extendIV.setImageResource(R.drawable.arrow_up);
//                    itemViewHolder.pressure_contentLL.setVisibility(View.VISIBLE);
//                }
//            }
//        });
//        //온도 레이아웃 접고 펼치기
//        itemViewHolder.temper_extendIV.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                if (itemViewHolder.temper_contentLL.getVisibility() == View.VISIBLE) {
//                    itemViewHolder.temper_extendIV.setImageResource(R.drawable.arrow_down);
//                    itemViewHolder.temper_contentLL.setVisibility(View.GONE);
//                } else {
//                    itemViewHolder.temper_extendIV.setImageResource(R.drawable.arrow_up);
//                    itemViewHolder.temper_contentLL.setVisibility(View.VISIBLE);
//                }
//            }
//        });
        //서비스 레이아웃 접고 펼치기
        itemViewHolder.breakdown_extendIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (itemViewHolder.breakdown_contentLL.getVisibility() == View.VISIBLE) {
                    itemViewHolder.breakdown_extendIV.setImageResource(R.drawable.arrow_down);
                    itemViewHolder.breakdown_contentLL.setVisibility(View.GONE);
                } else {
                    itemViewHolder.breakdown_extendIV.setImageResource(R.drawable.arrow_up);
                    itemViewHolder.breakdown_contentLL.setVisibility(View.VISIBLE);
                }
            }
        });
        //타임라인 레이아웃 접고 펼치기
        itemViewHolder.time_line_extendIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (itemViewHolder.time_line_contentLL.getVisibility() == View.VISIBLE) {
                    itemViewHolder.time_line_extendIV.setImageResource(R.drawable.arrow_down);
                    itemViewHolder.time_line_contentLL.setVisibility(View.GONE);
                } else {
                    itemViewHolder.time_line_extendIV.setImageResource(R.drawable.arrow_up);
                    itemViewHolder.time_line_contentLL.setVisibility(View.VISIBLE);
                }
            }
        });
        //A/S 레이아웃 접고 펼치기
        itemViewHolder.service_extendIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (itemViewHolder.service_contentLL.getVisibility() == View.VISIBLE) {
                    itemViewHolder.service_extendIV.setImageResource(R.drawable.arrow_down);
                    itemViewHolder.service_contentLL.setVisibility(View.GONE);
                } else {
                    itemViewHolder.service_extendIV.setImageResource(R.drawable.arrow_up);
                    itemViewHolder.service_contentLL.setVisibility(View.VISIBLE);
                }
            }
        });

        //전류 알람해제
        itemViewHolder.current_alarm_removeLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                ArrayList<String> mcl_idx_list = new ArrayList<>();
                ArrayList<String> mac_list = new ArrayList<>();
                ArrayList<String> msg_list = new ArrayList<>();

                for (int i = 0; i < items.get(position).getCtAlarms().size(); i++) {
                    if (items.get(position).getCtAlarms().get(i).getDelayTime() == null) {
                        mcl_idx_list.add(items.get(position).getCtAlarms().get(i).getMclIdx());
                        mac_list.add(items.get(position).getCtAlarms().get(i).getMcIotMac());
                        msg_list.add(items.get(position).getCtAlarms().get(i).getSensor());
                    }
                }

                Bundle bundle = new Bundle();
                bundle.putStringArrayList("mcl_idx_list", mcl_idx_list);
                bundle.putStringArrayList("mac_list", mac_list);
                bundle.putStringArrayList("msg_list", msg_list);

                alarmClickListener.clickBtn(bundle);
            }
        });
        //압력 알람해제
        itemViewHolder.pressure_alarm_removeLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                ArrayList<String> mcl_idx_list = new ArrayList<>();
                ArrayList<String> mac_list = new ArrayList<>();
                ArrayList<String> msg_list = new ArrayList<>();

                for (int i = 0; i < items.get(position).getPrAlarms().size(); i++) {
                    if (items.get(position).getPrAlarms().get(i).getDelayTime() == null) {
                        mcl_idx_list.add(items.get(position).getPrAlarms().get(i).getMclIdx());
                        mac_list.add(items.get(position).getPrAlarms().get(i).getMcIotMac());
                        msg_list.add(items.get(position).getPrAlarms().get(i).getSensor());
                    }
                }

                Bundle bundle = new Bundle();
                bundle.putStringArrayList("mcl_idx_list", mcl_idx_list);
                bundle.putStringArrayList("mac_list", mac_list);
                bundle.putStringArrayList("msg_list", msg_list);

                alarmClickListener.clickBtn(bundle);
            }
        });
        //온도 알람해제
        itemViewHolder.temper_alarm_removeLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                ArrayList<String> mcl_idx_list = new ArrayList<>();
                ArrayList<String> mac_list = new ArrayList<>();
                ArrayList<String> msg_list = new ArrayList<>();

                for (int i = 0; i < items.get(position).getTempAlarms().size(); i++) {
                    if (items.get(position).getTempAlarms().get(i).getDelayTime() == null) {
                        mcl_idx_list.add(items.get(position).getTempAlarms().get(i).getMclIdx());
                        mac_list.add(items.get(position).getTempAlarms().get(i).getMcIotMac());
                        msg_list.add(items.get(position).getTempAlarms().get(i).getSensor());
                    }
                }

                Bundle bundle = new Bundle();
                bundle.putStringArrayList("mcl_idx_list", mcl_idx_list);
                bundle.putStringArrayList("mac_list", mac_list);
                bundle.putStringArrayList("msg_list", msg_list);

                alarmClickListener.clickBtn(bundle);
            }
        });

//        //전류 작업일지
//        itemViewHolder.current_reportLL.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//
//                ArrayList<String> mcl_idx_list = new ArrayList<>();
//
//                for (int i = 0; i < items.get(position).getCtAlarms().size(); i++) {
//                    if (items.get(position).getCtAlarms().get(i).getDelayTime() == null) {
//                        returnClickListener.clickBtn();
//                        return;
//                    }
//                    mcl_idx_list.add(items.get(position).getCtAlarms().get(i).getMclIdx());
//                }
//
//                Bundle bundle = new Bundle();
//                bundle.putStringArrayList("mcl_idx_list", mcl_idx_list);
//                bundle.putString("position_k", position + "");
//                bundle.putString("type", "CT");
//                reportClickListener.clickBtn(bundle);
//            }
//        });
//
//        //압력 작업일지
//        itemViewHolder.pressure_reportLL.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//
//                ArrayList<String> mcl_idx_list = new ArrayList<>();
//
//                for (int i = 0; i < items.get(position).getPrAlarms().size(); i++) {
//                    if (items.get(position).getPrAlarms().get(i).getDelayTime() == null) {
//                        returnClickListener.clickBtn();
//                        return;
//                    }
//                    mcl_idx_list.add(items.get(position).getPrAlarms().get(i).getMclIdx());
//                }
//
//                Bundle bundle = new Bundle();
//                bundle.putStringArrayList("mcl_idx_list", mcl_idx_list);
//                bundle.putString("position_k", position + "");
//                bundle.putString("type", "PR");
//                reportClickListener.clickBtn(bundle);
//            }
//        });
//
//        //온도 작업일지
//        itemViewHolder.temper_reportLL.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//
//                ArrayList<String> mcl_idx_list = new ArrayList<>();
//
//                for (int i = 0; i < items.get(position).getTempAlarms().size(); i++) {
//                    if (items.get(position).getTempAlarms().get(i).getDelayTime() == null) {
//                        returnClickListener.clickBtn();
//                        return;
//                    }
//                    mcl_idx_list.add(items.get(position).getTempAlarms().get(i).getMclIdx());
//                }
//
//                Bundle bundle = new Bundle();
//                bundle.putStringArrayList("mcl_idx_list", mcl_idx_list);
//                bundle.putString("position_k", position + "");
//                bundle.putString("type", "TEMP");
//                reportClickListener.clickBtn(bundle);
//            }
//        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<AlarmData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        /**
         * 상단 정보
         **/
        TextView pd_nameTV, qr_codeTV, macTV;

        /**
         * 온도 감지
         **/
        TextView temper_countTV, temper_checkTV, temperTV;
        ImageView temper_extendIV, temper_countIV;
        LinearLayout temperLL, temper_reportLL, temper_alarm_removeLL, temper_contentLL, temper_alarmLL;
        RecyclerView temper_listRV;
        LinearLayout temperRL;

        /**
         * 압력 감지
         **/
        TextView pressure_countTV, pr_checkTV, pressureTV;
        ImageView pressure_extendIV, pressure_countIV;
        LinearLayout pressureLL, pressure_reportLL, pressure_alarm_removeLL, pressure_contentLL, pressure_alarmLL;
        RecyclerView pressure_listRV;
        LinearLayout pressureRL;

        /**
         * 압력 하한감지
         **/
        LinearLayout pressure_minLL, pressure_min_contentLL;
        RecyclerView pressure_min_listRV;

        /**
         * 전류 감지
         **/
        TextView current_countTV, ct_checkTV, currentTV;
        ImageView current_extendIV, current_countIV;
        LinearLayout currentLL, current_reportLL, current_alarm_removeLL, current_contentLL, current_alarmLL;
        RecyclerView current_listRV;
        LinearLayout currentRL;

        /**
         * 고장 감지
         **/
        TextView breakdown_contentTV, breakdown_dateTV, breakdown_engineerTV, serviceTV;
        ImageView breakdown_extendIV;
        LinearLayout breakdownLL, breakdown_contentLL;

        /**
         * IoT 타임라인
         **/
        LinearLayout time_lineLL, time_line_contentLL;
        TextView time_lineTV, time_line_countTV;
        ImageView time_line_extendIV;
        RecyclerView time_line_listRV;

        /**
         * A/S 레포트
         **/
        LinearLayout serviceLL, service_contentLL;
        TextView service_countTV;
        ImageView service_extendIV;
        RecyclerView service_listRV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            pd_nameTV = itemView.findViewById(R.id.pd_nameTV);
            qr_codeTV = itemView.findViewById(R.id.qr_codeTV);
            macTV = itemView.findViewById(R.id.macTV);

            temperLL = itemView.findViewById(R.id.temperLL);
            temper_contentLL = itemView.findViewById(R.id.temper_contentLL);
            temper_countTV = itemView.findViewById(R.id.temper_countTV);
            temper_extendIV = itemView.findViewById(R.id.temper_extendIV);
            temper_listRV = itemView.findViewById(R.id.temper_listRV);
            temper_reportLL = itemView.findViewById(R.id.temper_reportLL);
            temper_alarm_removeLL = itemView.findViewById(R.id.temper_alarm_removeLL);
            temper_checkTV = itemView.findViewById(R.id.temper_checkTV);
            temper_alarmLL = itemView.findViewById(R.id.temper_alarmLL);
            temperTV = itemView.findViewById(R.id.temperTV);
            temper_countIV = itemView.findViewById(R.id.temper_countIV);
            temperRL = itemView.findViewById(R.id.temperRL);

            pressureLL = itemView.findViewById(R.id.pressureLL);
            pressure_contentLL = itemView.findViewById(R.id.pressure_contentLL);
            pressure_countTV = itemView.findViewById(R.id.pressure_countTV);
            pressure_extendIV = itemView.findViewById(R.id.pressure_extendIV);
            pressure_listRV = itemView.findViewById(R.id.pressure_listRV);
            pressure_reportLL = itemView.findViewById(R.id.pressure_reportLL);
            pressure_alarm_removeLL = itemView.findViewById(R.id.pressure_alarm_removeLL);
            pr_checkTV = itemView.findViewById(R.id.pr_checkTV);
            pressure_alarmLL = itemView.findViewById(R.id.pressure_alarmLL);
            pressureTV = itemView.findViewById(R.id.pressureTV);
            pressureRL = itemView.findViewById(R.id.pressureRL);
            pressure_countIV = itemView.findViewById(R.id.pressure_countIV);

            currentLL = itemView.findViewById(R.id.currentLL);
            current_contentLL = itemView.findViewById(R.id.current_contentLL);
            current_countTV = itemView.findViewById(R.id.current_countTV);
            current_extendIV = itemView.findViewById(R.id.current_extendIV);
            current_listRV = itemView.findViewById(R.id.current_listRV);
            current_reportLL = itemView.findViewById(R.id.current_reportLL);
            current_alarm_removeLL = itemView.findViewById(R.id.current_alarm_removeLL);
            ct_checkTV = itemView.findViewById(R.id.ct_checkTV);
            current_alarmLL = itemView.findViewById(R.id.current_alarmLL);
            currentTV = itemView.findViewById(R.id.currentTV);
            currentRL = itemView.findViewById(R.id.currentRL);
            current_countIV = itemView.findViewById(R.id.current_countIV);

            breakdownLL = itemView.findViewById(R.id.breakdownLL);
            breakdown_contentLL = itemView.findViewById(R.id.breakdown_contentLL);
            breakdown_extendIV = itemView.findViewById(R.id.breakdown_extendIV);
            breakdown_contentTV = itemView.findViewById(R.id.breakdown_contentTV);
            breakdown_dateTV = itemView.findViewById(R.id.breakdown_dateTV);
            breakdown_engineerTV = itemView.findViewById(R.id.breakdown_engineerTV);
            serviceTV = itemView.findViewById(R.id.serviceTV);

            time_lineLL = itemView.findViewById(R.id.time_lineLL);
            time_lineTV = itemView.findViewById(R.id.time_lineTV);
            time_line_extendIV = itemView.findViewById(R.id.time_line_extendIV);
            time_line_contentLL = itemView.findViewById(R.id.time_line_contentLL);
            time_line_listRV = itemView.findViewById(R.id.time_line_listRV);
            time_line_countTV = itemView.findViewById(R.id.time_line_countTV);

            serviceLL = itemView.findViewById(R.id.serviceLL);
            service_countTV = itemView.findViewById(R.id.service_countTV);
            service_extendIV = itemView.findViewById(R.id.service_extendIV);
            service_contentLL = itemView.findViewById(R.id.service_contentLL);
            service_listRV = itemView.findViewById(R.id.service_listRV);

            pressure_minLL = itemView.findViewById(R.id.pressure_minLL);
            pressure_min_contentLL = itemView.findViewById(R.id.pressure_min_contentLL);
            pressure_min_listRV = itemView.findViewById(R.id.pressure_min_listRV);
        }

        void onBind(AlarmData data) {

            pd_nameTV.setText(data.getPdName());

            if (data.getQrCode() != null && !data.getQrCode().equals("")) {
                qr_codeTV.setText(data.getQrCode());
            } else {
                qr_codeTV.setText("QR 없음");
            }
            macTV.setText("MAC : " + data.getMcIotMac());

            if (data.getPrMinCnt() != null && Integer.parseInt(data.getPrMinCnt()) > 0) {
                pressure_minLL.setVisibility(View.VISIBLE);
            }

            if (data.getCtCnt() != null && Integer.parseInt(data.getCtCnt()) > 0) {
                currentLL.setVisibility(View.VISIBLE);
//                current_contentLL.setVisibility(View.GONE);
                current_extendIV.setImageResource(R.drawable.arrow_down);
                current_countTV.setText(data.getCtCnt());

            } else if (data.getCtReportCnt() != null && Integer.parseInt(data.getCtReportCnt()) > 0 && data.getCtReports() != null) {
                currentLL.setVisibility(View.VISIBLE);
//                current_contentLL.setVisibility(View.GONE);
                current_countTV.setText(data.getCtReportCnt());
                ct_checkTV.setVisibility(View.GONE);
                current_alarmLL.setVisibility(View.GONE);

                currentTV.setText("전력 점검일지");
                currentRL.setBackgroundResource(R.color.modern_gray);
                current_countIV.setImageResource(R.drawable.icon_light_blue_circle);

            } else {
                currentLL.setVisibility(View.GONE);
            }

            if (data.getPrCnt() != null && Integer.parseInt(data.getPrCnt()) > 0) {
                pressureLL.setVisibility(View.VISIBLE);
                pressure_extendIV.setImageResource(R.drawable.arrow_down);
//                pressure_contentLL.setVisibility(View.GONE);
                pressure_countTV.setText(data.getPrCnt());

            } else if (data.getPrReportCnt() != null && Integer.parseInt(data.getPrReportCnt()) > 0 && data.getPrReports() != null) {
                pressureLL.setVisibility(View.VISIBLE);
//                pressure_contentLL.setVisibility(View.GONE);
                pressure_countTV.setText(data.getPrReportCnt());
                pr_checkTV.setVisibility(View.GONE);
                pressure_alarmLL.setVisibility(View.GONE);

                pressureTV.setText("압력 점검일지");
                pressureRL.setBackgroundResource(R.color.modern_gray);
                pressure_countIV.setImageResource(R.drawable.icon_light_blue_circle);

            } else {
                pressureLL.setVisibility(View.GONE);
            }

            if (data.getTempCnt() != null && Integer.parseInt(data.getTempCnt()) > 0) {
                temperLL.setVisibility(View.VISIBLE);
                temper_extendIV.setImageResource(R.drawable.arrow_down);
//                temper_contentLL.setVisibility(View.GONE);
                temper_countTV.setText(data.getTempCnt());

            } else if (data.getTempReportCnt() != null && Integer.parseInt(data.getTempReportCnt()) > 0 && data.getTempReports() != null) {
                temperLL.setVisibility(View.VISIBLE);
//                temper_contentLL.setVisibility(View.GONE);
                temper_countTV.setText(data.getTempReportCnt());
                temper_checkTV.setVisibility(View.GONE);
                temper_alarmLL.setVisibility(View.GONE);

                temperTV.setText("온도 점검일지");
                temperRL.setBackgroundResource(R.color.modern_gray);
                temper_countIV.setImageResource(R.drawable.icon_light_blue_circle);

            } else {
                temperLL.setVisibility(View.GONE);
            }

            if (data.getServiceCnt() != null && Integer.parseInt(data.getServiceCnt()) > 0) {
                breakdownLL.setVisibility(View.VISIBLE);
//                breakdown_contentLL.setVisibility(View.GONE);
                breakdown_extendIV.setImageResource(R.drawable.arrow_down);

                breakdown_contentTV.setText(data.getServiceAlarms().get(0).getWoMemo());
                breakdown_dateTV.setText(data.getServiceAlarms().get(0).getWoCalldt());
                breakdown_engineerTV.setText(data.getServiceAlarms().get(0).getAgCeo() + " 기사 방문예정");

            } else {
                breakdownLL.setVisibility(View.GONE);
            }

            if (data.getServiceReportCnt() != null && Integer.parseInt(data.getServiceReportCnt()) > 0 && data.getServiceReports() != null) {
                serviceLL.setVisibility(View.VISIBLE);
                service_contentLL.setVisibility(View.GONE);
                service_countTV.setText(data.getServiceReportCnt());

            } else {
                serviceLL.setVisibility(View.GONE);
            }

            if (data.getTimeLineCnt() != null && Integer.parseInt(data.getTimeLineCnt()) > 0) {
                time_lineLL.setVisibility(View.VISIBLE);
                time_line_extendIV.setImageResource(R.drawable.arrow_up);
                time_line_contentLL.setVisibility(View.VISIBLE);
                time_line_countTV.setText(data.getTimeLineCnt());

                MachineManagementDetailAdapter detailAdapter = new MachineManagementDetailAdapter();
                time_line_listRV.setAdapter(detailAdapter);
                detailAdapter.addItem(data.getTimeLineAlarms());

            } else {
                time_lineLL.setVisibility(View.GONE);
            }


        }
    }
}