package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import kr.co.compcarecompany.Activity.FragmentActivity;
import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.Data.Product.ReportData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;
import kr.co.compcarecompany.Util.CustomView.AlarmListDialog;

public class MachineManagementReportAdapter2 extends RecyclerView.Adapter<MachineManagementReportAdapter2.ItemViewHolder> {

    private ArrayList<ReportData> items = new ArrayList<>();
    private Context context;
    private Handler handler;
    private ReportImageAdapter photo_adapter;

    private MachineManagementReportAdapter2.OnLoadMoreListener OnLoadMoreListener;

    public interface OnLoadMoreListener {
        void onLoadMore(int position);
    }

    public MachineManagementReportAdapter2(Context context, Handler handler, MachineManagementReportAdapter2.OnLoadMoreListener OnLoadMoreListener) {
        this.context = context;
        this.handler = handler;
        this.OnLoadMoreListener = OnLoadMoreListener;
    }

    @NonNull
    @Override
    public MachineManagementReportAdapter2.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_alarm_report_list, viewGroup, false);
        return new MachineManagementReportAdapter2.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MachineManagementReportAdapter2.ItemViewHolder itemViewHolder, int position) {

        try {
            itemViewHolder.onBind(items.get(position));
        } catch (ParseException e) {
            e.printStackTrace();
        }

        if (position == getItemCount() - 1) {
            if (OnLoadMoreListener != null) {
                OnLoadMoreListener.onLoadMore(position);
            }
        }

        itemViewHolder.dlg_report_pd_name_moreIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (items.get(position).isShow_name_all()) {
                    itemViewHolder.dlg_report_pd_name_moreIV.setImageResource(R.drawable.arrow_down);
                    itemViewHolder.dlg_report_pd_nameTV.setText(items.get(position).getPdNameArr().get(0).getPdName() + " 외 " + (items.get(position).getPdNameArr().size()-1));
                    items.get(position).setShow_name_all(false);
                } else {
                    itemViewHolder.dlg_report_pd_name_moreIV.setImageResource(R.drawable.arrow_up);
                    String pd_name = "";
                    for (int i = 0; i < items.get(position).getPdNameArr().size(); i++) {
                        if (i < items.get(position).getPdNameArr().size() - 1)
                            pd_name = pd_name + items.get(position).getPdNameArr().get(i).getPdName() + "\n";
                        else
                            pd_name = pd_name + items.get(position).getPdNameArr().get(i).getPdName();
                    }
                    itemViewHolder.dlg_report_pd_nameTV.setText(pd_name);
                    items.get(position).setShow_name_all(true);
                }
            }
        });

        int px = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 6f, context.getResources().getDisplayMetrics());
        photo_adapter = new ReportImageAdapter(context, 30*px);

        if (items.get(position).getArIdx() != null) {
            if (items.get(position).getPhotoList() != null && items.get(position).getPhotoList().size() > 0) {
                itemViewHolder.dlg_report_photoLL.setVisibility(View.VISIBLE);
                itemViewHolder.dlg_report_photoRV.setAdapter(photo_adapter);

                String manager_uri = "https://www.compcare.co.kr/uploads/alarm_report/";
                ArrayList<String> photo_uri = new ArrayList<>();

                for (int i = 0; i < items.get(position).getPhotoList().size(); i++) {
                    photo_uri.add(manager_uri + items.get(position).getPhotoList().get(i).getPfiFilename());
                }
                photo_adapter.addItem(photo_uri);

            } else {
                itemViewHolder.dlg_report_photoLL.setVisibility(View.GONE);
            }

        } else {

            if (items.get(position).getPhotoList() != null && items.get(position).getPhotoList().size() > 0) {
                itemViewHolder.dlg_service_photoLL.setVisibility(View.VISIBLE);
                itemViewHolder.dlg_service_photoRV.setAdapter(photo_adapter);

                String manager_uri = "https://www.compcare.co.kr/uploads/work/";
                ArrayList<String> photo_uri = new ArrayList<>();

                for (int i = 0; i < items.get(position).getPhotoList().size(); i++) {
                    photo_uri.add(manager_uri + items.get(position).getPhotoList().get(i).getPfiFilename());
                }
                photo_adapter.addItem(photo_uri);

            } else {
                itemViewHolder.dlg_service_photoLL.setVisibility(View.GONE);
            }

        }

        itemViewHolder.dlg_report_alarm_listIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//                AlarmListDialog dialog = new AlarmListDialog(context, handler, items.get(position).getArIdx(), items.get(position).getCpIdx());
//                dialog.show();
            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<ReportData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void addItemMore(ArrayList<ReportData> lst) {
        items.addAll(lst);
        notifyItemRangeChanged(0, items.size());
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        //작업일지
        TextView dlg_report_cp_nameTV, dlg_report_airlineTV, dlg_report_ar_workerTV, dlg_report_ar_work_dateTV, dlg_report_pd_nameTV, dlg_report_ar_contentTV;
        ImageView dlg_report_alarm_listIV, dlg_report_pd_name_moreIV;
        LinearLayout dlg_report_photoLL, reportLL;
        RecyclerView dlg_report_photoRV;

        //서비스 레포트
        TextView dlg_service_workerTV, dlg_service_work_dateTV, dlg_service_pd_nameTV, dlg_service_ar_contentTV, dlg_service_wo_memoTV;
        //        ImageView dlg_service_pd_name_moreIV;
        LinearLayout dlg_service_photoLL, serviceLL;
        RecyclerView dlg_service_photoRV;

        LinearLayout report_listLL;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            report_listLL = itemView.findViewById(R.id.report_listLL);

            dlg_report_cp_nameTV = itemView.findViewById(R.id.dlg_report_cp_nameTV);
            dlg_report_airlineTV = itemView.findViewById(R.id.dlg_report_airlineTV);

            reportLL = itemView.findViewById(R.id.reportLL);
            dlg_report_ar_workerTV = itemView.findViewById(R.id.dlg_report_ar_workerTV);
            dlg_report_ar_work_dateTV = itemView.findViewById(R.id.dlg_report_ar_work_dateTV);
            dlg_report_pd_nameTV = itemView.findViewById(R.id.dlg_report_pd_nameTV);
            dlg_report_ar_contentTV = itemView.findViewById(R.id.dlg_report_ar_contentTV);
            dlg_report_alarm_listIV = itemView.findViewById(R.id.dlg_report_alarm_listIV);
            dlg_report_pd_name_moreIV = itemView.findViewById(R.id.dlg_report_pd_name_moreIV);
            dlg_report_photoLL = itemView.findViewById(R.id.dlg_report_photoLL);
            dlg_report_photoRV = itemView.findViewById(R.id.dlg_report_photoRV);

            serviceLL = itemView.findViewById(R.id.serviceLL);
            dlg_service_workerTV = itemView.findViewById(R.id.dlg_service_workerTV);
            dlg_service_work_dateTV = itemView.findViewById(R.id.dlg_service_work_dateTV);
            dlg_service_pd_nameTV = itemView.findViewById(R.id.dlg_service_pd_nameTV);
            dlg_service_ar_contentTV = itemView.findViewById(R.id.dlg_service_ar_contentTV);
            dlg_service_photoLL = itemView.findViewById(R.id.dlg_service_photoLL);
            dlg_service_photoRV = itemView.findViewById(R.id.dlg_service_photoRV);
            dlg_service_wo_memoTV = itemView.findViewById(R.id.dlg_service_wo_memoTV);

        }

        void onBind(ReportData data) throws ParseException {
            dlg_report_cp_nameTV.setText(data.getCpName());
            dlg_report_airlineTV.setText("[ " + data.getMcAirline() + " ]");

            if (data.getArIdx() != null) {
                serviceLL.setVisibility(View.GONE);
                reportLL.setVisibility(View.VISIBLE);
                dlg_report_alarm_listIV.setVisibility(View.VISIBLE);

                dlg_report_ar_workerTV.setText(data.getArWorker());
                dlg_report_ar_work_dateTV.setText(data.getArWorkDate()+" 작성");
                dlg_report_pd_nameTV.setText(data.getPdNameArr().toString());

                String quick = Common.getInstance().isNullText(data.getArContentQuick());
                String content = Common.getInstance().isNullText(data.getArContent());
                if (!TextUtils.isEmpty(quick)) content = " "+content;
                dlg_report_ar_contentTV.setText(quick + content);

                if (data.getPdNameArr().size() > 1) {
                    dlg_report_pd_nameTV.setText(data.getPdNameArr().get(0).getPdName() + " 외 " + (data.getPdNameArr().size() - 1));
                    dlg_report_pd_name_moreIV.setVisibility(View.VISIBLE);

                } else {
                    dlg_report_pd_nameTV.setText(data.getPdNameArr().get(0).getPdName());
                    dlg_report_pd_name_moreIV.setVisibility(View.GONE);
                }


            } else {
                report_listLL.setBackgroundResource(R.drawable.border_red_fill_white_round_stroke2_opa);

                reportLL.setVisibility(View.GONE);
                serviceLL.setVisibility(View.VISIBLE);
                dlg_report_alarm_listIV.setVisibility(View.GONE);

                dlg_service_workerTV.setText(data.getWrWorkerName2() + " 기사");

                if (data.getWrEnddt() != null) {
                    SimpleDateFormat beforeSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date beforeDate = beforeSDF.parse(data.getWrEnddt());
                    SimpleDateFormat afterSDF = new SimpleDateFormat("yyyy.MM.dd");
                    String afterDate = afterSDF.format(beforeDate);
                    dlg_service_work_dateTV.setText(afterDate + " 조치");
                }

                dlg_service_pd_nameTV.setText(data.getPdName());
                dlg_service_wo_memoTV.setText(data.getWoMemo());
                dlg_service_ar_contentTV.setText(data.getWoMemo());

                String quick = Common.getInstance().isNullText(data.getWrMemoReportSub());
                String content = Common.getInstance().isNullText(data.getWrMemoReport());
                if (TextUtils.isEmpty(quick) && TextUtils.isEmpty(content)) quick = "(점검 완료)";
                dlg_service_ar_contentTV.setText(quick + content);

            }
        }
    }
}


