package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Company.CompanyData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.MyOnItemClick;

public class MainTapListAdapter extends RecyclerView.Adapter<MainTapListAdapter.ItemViewHolder> {

    Context context;
    Handler handler;
    MyOnItemClick callback;

    private ArrayList<CompanyData> items = new ArrayList<>();

    public MainTapListAdapter(@NonNull Context context, MyOnItemClick callback) {
        this.context = context;
        this.callback = callback;
    }


    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_tablist, viewGroup, false);

        return new ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

//        if (items.size() > 1 && position < items.size() -1) {
//            itemViewHolder.divideTV.setVisibility(View.VISIBLE);
//        }

        itemViewHolder.item_tap_listLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Bundle bundle = new Bundle();
                bundle.putString("item_position", position+"");
                callback.onClick(bundle);
            }
        });

    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(CompanyData data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.add(data);
        notifyDataSetChanged();
    }

    public void addItems(ArrayList<CompanyData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
//        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView item_tap_listTV, divideTV;
        LinearLayout item_tap_listLL;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            item_tap_listLL = itemView.findViewById(R.id.item_tap_listLL);
            item_tap_listTV = itemView.findViewById(R.id.item_tap_listTV);
//            divideTV = itemView.findViewById(R.id.divideTV);

        }

        void onBind(CompanyData data) {

            item_tap_listTV.setText(data.getCpName());

//            if(data.isSelected()){
//
//                item_tap_listLL.setBackgroundResource(R.drawable.bg_round_purple_top);
//                item_tap_listTV.setTextColor(Color.WHITE);
//
//            } else {
//
//                item_tap_listLL.setBackgroundResource(R.drawable.bg_round_white_top);
//                item_tap_listTV.setTextColor(Color.parseColor("#9134A1"));
//            }

            if(data.isSelected()){

                item_tap_listLL.setBackgroundResource(R.drawable.bg_round_purple);
                item_tap_listTV.setTextColor(Color.WHITE);

            } else {

                item_tap_listLL.setBackgroundResource(R.drawable.bg_round_white);
                item_tap_listTV.setTextColor(Color.parseColor("#9134A1"));
            }
        }
    }
}
