package kr.co.compcarecompany.Util.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.text.Editable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class OptionInterlockAdapter extends RecyclerView.Adapter<OptionInterlockAdapter.ItemViewHolder> {

    Context context;

    private ArrayList<MachineItem> items = new ArrayList<>();
    private OptionInterlockAdapter.checkClickListener checkClickListener;


    public interface checkClickListener {
        void clickBtn(int position, String mc_idx , String mac, Editable text);
        void clickCancelBtn(int position, String mc_idx, String mac, Editable text);
    }

    public OptionInterlockAdapter(@NonNull Context context, OptionInterlockAdapter.checkClickListener checkClickListener) {
        this.context = context;
        this.checkClickListener = checkClickListener;
    }

    @NonNull
    @Override
    public OptionInterlockAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_interlock_list, viewGroup, false);
        return new OptionInterlockAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull OptionInterlockAdapter.ItemViewHolder itemViewHolder, @SuppressLint("RecyclerView") int position) {
        itemViewHolder.onBind(items.get(position));
        itemViewHolder.interlock_checkCB.setOnClickListener(new View.OnClickListener() {

            private boolean False;

            @Override
            public void onClick(View view) {
                if (itemViewHolder.interlock_checkCB.isChecked()) {

                    if(!TextUtils.isEmpty(itemViewHolder.mc_yeon_index.getText())){
                        Log.d("로그볼거야1", String.valueOf(itemViewHolder.mc_yeon_index.getText()));
                        itemViewHolder.mc_yeon_index.setBackgroundColor(Color.rgb(204, 204, 204));
                        itemViewHolder.mc_yeon_index.setEnabled(False); // 연동제어 사용, 사용안함
                        checkClickListener.clickBtn(position, items.get(position).getMcIdx(), items.get(position).getMcIotMac(), itemViewHolder.mc_yeon_index.getText());

                    }else{
                        Log.d("로그볼거야2", String.valueOf(itemViewHolder.mc_yeon_index.getText()));
                        checkClickListener.clickCancelBtn(position, items.get(position).getMcIdx(), items.get(position).getMcIotMac(), itemViewHolder.mc_yeon_index.getText());
                        itemViewHolder.mc_yeon_index.setBackgroundColor(Color.rgb(255,255,255));
                        itemViewHolder.mc_yeon_index.setEnabled(False); // 연동제어 사용, 사용안함
                    }

                }else{
                    checkClickListener.clickCancelBtn(position, items.get(position).getMcIdx(), items.get(position).getMcIotMac(), itemViewHolder.mc_yeon_index.getText());
                    itemViewHolder.mc_yeon_index.setBackgroundColor(Color.rgb(255,255,255));
                    itemViewHolder.mc_yeon_index.setEnabled(true); // 연동제어 사용, 사용안함
                }
            }
        });
    }



    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<MachineItem> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);

        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    public static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView interlock_mc_iot_macTV, interlock_pd_nameTV, interlock_typeTV;
        CheckBox interlock_checkCB;
        EditText mc_yeon_index;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            interlock_mc_iot_macTV = itemView.findViewById(R.id.interlock_mc_iot_macTV);
            interlock_pd_nameTV = itemView.findViewById(R.id.interlock_pd_nameTV);
            interlock_typeTV = itemView.findViewById(R.id.interlock_typeTV);
            interlock_checkCB = itemView.findViewById(R.id.interlock_checkCB);
            mc_yeon_index = itemView.findViewById(R.id.mc_yeon_index);

        }
        int i=0 ;
        void onBind(MachineItem data) { // 마스터 전용!!!

            if (!TextUtils.isEmpty(data.getMcIotMac())) {
                interlock_mc_iot_macTV.setText("MAC ( " + data.getMcIotMac() + " )");
            }
               interlock_pd_nameTV.setText(data.getPdName());
            if(i == 0) {
                mc_yeon_index.setText(data.getMcCrossNum());
                i = 2;
            }


              interlock_typeTV.setText("Slave");
              interlock_typeTV.setBackgroundResource(R.drawable.border_dark_gray_fill_white);
              interlock_typeTV.setTextColor(Color.BLACK);


            /*
            interlock_checkCB.setChecked(data.isSelected());

             */
        }
    }
}
