package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class ReportAdapter extends RecyclerView.Adapter<ReportAdapter.ItemViewHolder> {

    Context context;
    Handler handler;

    private ArrayList<AlarmData> items = new ArrayList<>();

    public ReportAdapter(@NonNull Context context) {
        this.context = context;
    }

    @NonNull
    @Override
    public ReportAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_alarm_report_new, viewGroup, false);

        return new ReportAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ReportAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<AlarmData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView item_macTV, item_product_nameTV, item_sensor_informTV, item_valueTV, item_sensorTV, item_timeTV, item_read_timeTV, item_check_listTV, item_product_qrTV;
        LinearLayout item_read_timeLL, item_check_listLL;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            item_macTV = itemView.findViewById(R.id.item_macTV);
            item_product_nameTV = itemView.findViewById(R.id.item_product_nameTV);
            item_sensor_informTV = itemView.findViewById(R.id.item_sensor_informTV);
            item_valueTV = itemView.findViewById(R.id.item_valueTV);
            item_sensorTV = itemView.findViewById(R.id.item_sensorTV);
            item_timeTV = itemView.findViewById(R.id.item_timeTV);
            item_read_timeTV = itemView.findViewById(R.id.item_read_timeTV);
            item_read_timeLL = itemView.findViewById(R.id.item_read_timeLL);
            item_check_listTV = itemView.findViewById(R.id.item_check_listTV);
            item_check_listLL = itemView.findViewById(R.id.item_check_listLL);
            item_product_qrTV = itemView.findViewById(R.id.item_product_qrTV);

        }

        void onBind(AlarmData data) {

            item_macTV.setText(data.getMcIotMac());
            item_timeTV.setText(data.getPushDt());
            item_product_nameTV.setText(data.getPdName());
//            item_product_nameTV.setText(data.getMachineData().getPdName());
//            if(data.getMachineData().getQrCode() != null)
//            item_product_qrTV.setText(data.getMachineData().getQrCode().toString());
            item_product_qrTV.setText(data.getQrCode());

            String type;
            String unit;
            float up;
            float down;
            String warn;
            switch (data.getSensor()) {
                case "0":
                    type = "IoT 재시작";
                    unit = "";
                    item_valueTV.setVisibility(View.GONE);
                    item_check_listLL.setVisibility(View.GONE);
                    break;
                case "1":
                    type = "전류1";
                    unit = " A";
//                    up = Float.parseFloat(data.getMachineData().getMcCurrent1Up());
//                    down = Float.parseFloat(data.getMachineData().getMcCurrent1Down());
                    item_check_listTV.setText("마그넷트 접촉 체크, 차단기 전선 체크, 모터저항이 높아짐");
                    warn = "전류";
                    break;
                case "2":
                    type = "전류2";
                    unit = " A";
//                    up = Float.parseFloat(data.getMachineData().getMcCurrent2Up());
//                    down = Float.parseFloat(data.getMachineData().getMcCurrent2Down());
                    item_check_listTV.setText("마그넷트 접촉 체크, 차단기 전선 체크, 모터저항이 높아짐");
                    warn = "전류";
                    break;
                case "3":
                    type = "전류3";
                    unit = " A";
//                    up = Float.parseFloat(data.getMachineData().getMcCurrent3Up());
//                    down = Float.parseFloat(data.getMachineData().getMcCurrent3Down());
                    item_check_listTV.setText("마그넷트 접촉 체크, 차단기 전선 체크, 모터저항이 높아짐");
                    warn = "전류";
                    break;
                case "4":
                    type = "압력1";
                    unit = " Bar";
//                    up = Float.parseFloat(data.getMachineData().getMcPressure1Up());
//                    down = Float.parseFloat(data.getMachineData().getMcPressure1Down());
                    item_check_listTV.setText("토출밸브 체크, 토출밸브 막힘 확인");
                    warn = "압력";
                    break;
                case "5":
                    type = "압력2";
                    unit = " Bar";
//                    up = Float.parseFloat(data.getMachineData().getMcPressure2Up());
//                    down = Float.parseFloat(data.getMachineData().getMcPressure2Down());
                    item_check_listTV.setText("토출밸브 체크, 토출밸브 막힘 확인");
                    warn = "압력";
                    break;
                case "6":
                    type = "압력3";
                    unit = " Bar";
//                    up = Float.parseFloat(data.getMachineData().getMcPressure3Up());
//                    down = Float.parseFloat(data.getMachineData().getMcPressure3Down());
                    item_check_listTV.setText("토출밸브 체크, 토출밸브 막힘 확인");
                    warn = "압력";
                    break;
                case "7":
                    type = "온도NTC";
                    unit = " ℃";
//                    up = Float.parseFloat(data.getMachineData().getMcTempNtcUp());
//                    down = Float.parseFloat(data.getMachineData().getMcTempNtcDown());
                    item_check_listTV.setText("오일량 체크, 쿨러먼지 청소 확인");
                    warn = "온도";
                    break;
                case "8":
                    type = "온도PT100";
                    unit = " ℃";
//                    up = Float.parseFloat(data.getMachineData().getMcTempPtUp());
//                    down = Float.parseFloat(data.getMachineData().getMcTempPtDown());
                    item_check_listTV.setText("오일량 체크, 쿨러먼지 청소 확인");
                    warn = "온도";
                    break;
                case "9":
                    type = "온도NTC_2";
                    unit = " ℃";
//                    up = Float.parseFloat(data.getMachineData().getMcTempNtc2Up());
//                    down = Float.parseFloat(data.getMachineData().getMcTempNtc2Down());
                    item_check_listTV.setText("오일량 체크, 쿨러먼지 청소 확인");
                    warn = "온도";
                    break;
                case "100":
                    type = "기계 한계값 초과로 서비스 접수";
                    unit = "";
                    item_valueTV.setVisibility(View.GONE);
                    item_check_listLL.setVisibility(View.GONE);
                    break;
                case "200":
                    type = "소모품 만료";
                    unit = "";
                    item_valueTV.setVisibility(View.GONE);
                    item_check_listLL.setVisibility(View.GONE);
                    break;
                case "300":
                    type = "메인 모터 과부하로 서비스 접수";
                    unit = "";
                    item_valueTV.setVisibility(View.GONE);
                    item_check_listLL.setVisibility(View.GONE);
                    break;
                case "400":
                    type = "메인 3상 전원 차단으로 서비스 접수";
                    unit = "";
                    item_valueTV.setVisibility(View.GONE);
                    item_check_listLL.setVisibility(View.GONE);
                    break;
                case "500":
                    type = "메인모터 오버로드";
                    unit = "";
                    item_valueTV.setVisibility(View.GONE);
                    item_check_listLL.setVisibility(View.GONE);
                    break;
                case "600":
                    type = "팬모터 오버로드";
                    unit = "";
                    item_valueTV.setVisibility(View.GONE);
                    item_check_listLL.setVisibility(View.GONE);
                    break;
                default:
                    type = data.getSensor();
                    unit = "";
                    item_check_listTV.setText("미확인 알람");
                    warn = "";
                    break;
            }

            item_sensorTV.setText(type);
            item_valueTV.setText(Common.getInstance().valueConvert1(Common.getInstance().isNullToZero(data.getSensorValue())) + unit);
            if(data.getReadTime() != null){
                item_read_timeTV.setText(data.getReadTime());
                item_read_timeLL.setVisibility(View.VISIBLE);
            }
//            if(Integer.parseInt(data.getSensorValue()) > up){
//                item_sensor_informTV.setText(warn+" 상승함");
//
//            } else if (Integer.parseInt(data.getSensorValue()) < down){
//                item_sensor_informTV.setText(warn+" 하강함");
//            }
        }
    }
}
