package kr.co.compcarecompany.Util.Adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.InvoiceData;
import kr.co.compcarecompany.R;

public class ServiceInvoiceAdapter extends RecyclerView.Adapter<ServiceInvoiceAdapter.ItemViewHolder> {

    public ServiceInvoiceAdapter() {
    }

    private ArrayList<InvoiceData> items = new ArrayList<>();

    @NonNull
    @Override
    public ServiceInvoiceAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_service_invoice_list, viewGroup, false);
        return new ServiceInvoiceAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ServiceInvoiceAdapter.ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<InvoiceData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView pd_nameTV, pd_sizeTV, pd_cntTV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            pd_nameTV = itemView.findViewById(R.id.pd_nameTV);
            pd_sizeTV = itemView.findViewById(R.id.pd_sizeTV);
            pd_cntTV = itemView.findViewById(R.id.pd_cntTV);

        }

        void onBind(InvoiceData data) {

            pd_nameTV.setText(data.getPdName());
            pd_sizeTV.setText(data.getPdSize());
            pd_cntTV.setText(data.getPdCnt());

        }
    }
}