package kr.co.compcarecompany.Util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ConvertTimeZone {//GMT to KOREA

    public void ConvertTimeZone() {
    }

    public String convertKoreaTimeS(String time) throws ParseException {

        String form = "yyyy-MM-dd'T'HH:mm:ss'Z'";

        SimpleDateFormat inputFormat = new SimpleDateFormat
                (form, Locale.KOREA);
        inputFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));

        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        // Adjust locale and zone appropriately
        Date date = inputFormat.parse(time);
        String outputText = outputFormat.format(date);
        return outputText;
    }

    public String convertKoreaTimeS2(String time) throws ParseException {

        String form = "yyyy-MM-dd'T'HH:mm:ss'Z'";

        SimpleDateFormat inputFormat = new SimpleDateFormat
                (form, Locale.KOREA);
        inputFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));

        SimpleDateFormat outputFormat = new SimpleDateFormat("MM.dd HH:mm:ss");
        // Adjust locale and zone appropriately
        Date date = inputFormat.parse(time);
        String outputText = outputFormat.format(date);
        return outputText;
    }

    public String convertKoreaTimeM(String time) throws ParseException {

        String form = "yyyy-MM-dd'T'HH:mm:ss'Z'";

        SimpleDateFormat inputFormat = new SimpleDateFormat
                (form, Locale.KOREA);
        inputFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));

        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        // Adjust locale and zone appropriately
        Date date = inputFormat.parse(time);
        String outputText = outputFormat.format(date);
        return outputText;
    }

    public String convertKoreaTimeH(String time) throws ParseException {

        String form = "yyyy-MM-dd'T'HH:mm:ss'Z'";

        SimpleDateFormat inputFormat = new SimpleDateFormat
                (form, Locale.KOREA);
        inputFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));

        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy년 MM월 dd일 HH시");
        // Adjust locale and zone appropriately
        Date date = inputFormat.parse(time);
        String outputText = outputFormat.format(date);
        return outputText;
    }

    public String convertKoreaTime(String time) throws ParseException {

        String form = "yyyy-MM-dd'T'HH:mm:ss'Z'";

        SimpleDateFormat inputFormat = new SimpleDateFormat
                (form, Locale.KOREA);
        inputFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));

        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy.MM.dd a HH:mm");
        // Adjust locale and zone appropriately
        Date date = inputFormat.parse(time);
        String outputText = outputFormat.format(date);
        return outputText;
    }

    public String convertKoreaTimeD(String time) throws ParseException {

        String form = "yyyy-MM-dd'T'HH:mm:ss'Z'";

        SimpleDateFormat inputFormat = new SimpleDateFormat
                (form, Locale.KOREA);
        inputFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));

        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy.MM.dd");
        // Adjust locale and zone appropriately
        Date date = inputFormat.parse(time);
        String outputText = outputFormat.format(date);
        return outputText;
    }

    public String convertGmtTime(String time) throws ParseException {

        String form = "yyyyMMddHHmmss";

        SimpleDateFormat inputFormat = new SimpleDateFormat(form, Locale.KOREA);

        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        outputFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        // Adjust locale and zone appropriately
        Date date = inputFormat.parse(time);
        String outputText = outputFormat.format(date);
        return outputText;
    }
}
