package kr.co.compcarecompany.Util.CustomSeekBar;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;

import java.util.ArrayList;
import java.util.List;

public class ProgressDrawable extends Drawable {

    private int parts = 10;
    private int range = 65;
    private Paint paint = null;
    private int fillColor = Color.parseColor("#FFC300");
    private int emptyColor = Color.parseColor("#32AE0D");
    private int thumbColor = Color.parseColor("#dd3333");
    private int separatorColor = Color.parseColor("#FFFFFF");
    private RectF rectFill = null;
    private RectF rectEmpty = null;
    private RectF thumbFill = null;
    private List<RectF> separators = null;

    public ProgressDrawable(int parts, int range) {
        this.parts = parts;
        this.range = range;
        this.paint = new Paint(Paint.ANTI_ALIAS_FLAG);
        this.separators = new ArrayList<RectF>();
    }

    @Override
    protected boolean onLevelChange(int level) {
        invalidateSelf();
        return true;
    }

    @Override
    public void draw(Canvas canvas) {
        // Calculate values
        Rect b = getBounds();
        float width = b.width();
        float height = b.height();

        int spaceFilled = (int) (getLevel() * width / 10000);
        int radRilled = (int) (range * width / 10000);
        this.rectFill = new RectF(0, 0, radRilled, height);
        this.rectEmpty = new RectF(radRilled, 0, width, height);
        this.thumbFill = new RectF(spaceFilled + 2, 0, spaceFilled - 2, height);

        int spaceBetween = (int) (width / 100);
        int widthPart = (int) (width / this.parts - (int) (0.9 * spaceBetween));
        int startX = widthPart;
        for (int i = 0; i < this.parts - 1; i++) {
            this.separators.add(new RectF(startX, 0, startX + spaceBetween, height));
            startX += spaceBetween + widthPart;
        }

        // Foreground
        this.paint.setColor(this.fillColor);
//        canvas.drawRect(this.rectFill, this.paint);
        canvas.drawRect(new RectF(10, 0, radRilled, height), this.paint);
        canvas.drawRoundRect(this.rectFill, 10, 10, this.paint);

        //Thumb
        this.paint.setColor(this.thumbColor);
        canvas.drawRect(this.thumbFill, this.paint);

        // Background
        this.paint.setColor(this.emptyColor);
//        canvas.drawRect(this.rectEmpty, this.paint);
        canvas.drawRect(new RectF(radRilled, 0, width - 10, height), this.paint);
        canvas.drawRoundRect(this.rectEmpty, 10, 10, this.paint);

        // Separator
        this.paint.setColor(this.separatorColor);
        for (RectF separator : this.separators) {
            canvas.drawRect(separator, this.paint);
        }
    }

    @Override
    public void setAlpha(int alpha) {
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
    }

    @Override
    public int getOpacity() {
        return PixelFormat.TRANSLUCENT;
    }
}