package kr.co.compcarecompany.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.HashMap;

import kr.co.compcarecompany.Data.ArrayItem;
import kr.co.compcarecompany.Data.Company.CompanyData;
import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Adapter.AlarmRemoveListAdapter;


public class AlarmRemoveListDialog extends Dialog {

    private Context context;
    private TextView dlg_closeTV, pt_nameTV, cp_nameTV;
    private RecyclerView dlg_remove_listRV;
    private ArrayItem<AlarmData> alarmItems;
    private AlarmRemoveListAdapter adapter;

    public AlarmRemoveListDialog(@NonNull Context context, ArrayItem<AlarmData> alarmItems) {
        super(context);
        this.context = context;
        this.alarmItems = alarmItems;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_alarm_remove_list);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        dlg_remove_listRV = findViewById(R.id.dlg_remove_listRV);
        dlg_closeTV = findViewById(R.id.dlg_closeTV);
        pt_nameTV = findViewById(R.id.pt_nameTV);
        cp_nameTV = findViewById(R.id.cp_nameTV);
        adapter = new AlarmRemoveListAdapter(context);
        dlg_remove_listRV.setAdapter(adapter);

        pt_nameTV.setText(alarmItems.getArrayitem().get(0).getPtName());
        cp_nameTV.setText(alarmItems.getArrayitem().get(0).getCpName());

        adapter.addItem(alarmItems.getArrayitem());

        init_Listener();
    }

    void init_Listener() {

        dlg_closeTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
    }
}



