package kr.co.compcarecompany.Util.CustomView;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.text.TextUtils;
import android.widget.TextView;

import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.components.MarkerView;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.utils.MPPointF;

import java.text.ParseException;
import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;
import kr.co.compcarecompany.Util.ConvertTimeZone;

public class CustomMarkerView extends MarkerView {

    private TextView marker_valueTV, marker_dateTV;
    private ArrayList<String> time, data;
    private String type, date_type;
    private ArrayList<MachineItem> monitoringData;

    private MPPointF mOffset2 = new MPPointF();

    public CustomMarkerView(Context context, int layoutResource, ArrayList<String> time, String type, ArrayList<String> data) {
        super(context, layoutResource);

        marker_valueTV = findViewById(R.id.marker_valueTV);
        marker_dateTV = findViewById(R.id.marker_dateTV);

        this.time = time;
        this.type = type;
        this.data = data;

    }

    public CustomMarkerView(Context context, int layoutResource, ArrayList<MachineItem> monitoringData, String type, String date_type) {
        super(context, layoutResource);

        marker_valueTV = findViewById(R.id.marker_valueTV);
        marker_dateTV = findViewById(R.id.marker_dateTV);

        this.type = type;
        this.date_type = date_type;
        this.monitoringData = monitoringData;

    }

    @Override
    public void refreshContent(Entry e, Highlight highlight) {

        int index = (int) e.getX();

        String value;

        if (monitoringData != null) {
            value = Common.getInstance().valueConvert1(monitoringData.get(index).getMcAirLeakValue());
            ConvertTimeZone timeZone = new ConvertTimeZone();
            try {
                String time = "";
                if ((date_type.equals("day"))) {
                    time = timeZone.convertKoreaTimeS(monitoringData.get(index).getTime());
                    time = time.substring(11, 16);

                } else {
                    time = timeZone.convertKoreaTimeD(monitoringData.get(index).getTime());
                    time = time.substring(8)+"일";
                }
                marker_dateTV.setText(time);

            } catch (ParseException ex) {
                ex.printStackTrace();
            }

        } else {
            value = data.get(index);
            marker_dateTV.setText(time.get(index));
        }

        switch (type) {
            case "power_consumption":
                marker_valueTV.setText(Common.getInstance().valueConvert(value) + " kW");
                break;
            case "current1":
            case "current2":
            case "current3":
                marker_valueTV.setText(Common.getInstance().valueConvert(value) + " A");
                break;
            case "pressure1":
            case "pressure2":
            case "pressure3":
                marker_valueTV.setText(value + " Bar");
                break;
            case "temperatureNtc":
            case "temperatureNtc2":
            case "temperaturePt":
                marker_valueTV.setText(Common.getInstance().valueConvert(value) + " ℃");
                break;
        }
        super.refreshContent(e, highlight);
    }

    @Override
    public MPPointF getOffsetForDrawingAtPoint(float posX, float posY) {

        MPPointF offset = getOffset();
        mOffset2.x = offset.x;
        mOffset2.y = offset.y;

        Chart chart = getChartView();

        float width = getWidth();
        float height = getHeight();

        if (posX + mOffset2.x < 0) {
            mOffset2.x = -posX;

        } else if (chart != null && posX + width + mOffset2.x > chart.getWidth()) {
            mOffset2.x = chart.getWidth() - posX - width;
        }

        if (posY + mOffset2.y < 0) {
            mOffset2.y = -posY;

        } else if (chart != null && posY + height + mOffset2.y > chart.getHeight()) {
            mOffset2.y = chart.getHeight() - posY - height;

        } else if (chart != null && posY + height + mOffset2.y < chart.getHeight()) {
            mOffset2.y = -chart.getY() - height;
        }

        return mOffset2;
    }

    @Override
    public void draw(Canvas canvas, float posX, float posY) {

        MPPointF offset = getOffsetForDrawingAtPoint(posX, posY);
        int saveId = canvas.save();

        Paint paint = new Paint();
        paint.setColor(Color.RED);
        paint.setStrokeWidth(7f);
        canvas.drawCircle(posX, posY, 7f, paint);
        canvas.translate(posX + offset.x, posY + offset.y);
        draw(canvas);
        canvas.restoreToCount(saveId);
    }
}